import React, { useEffect, useState } from 'react';
import { Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { InterDataType } from '~/api/interface';
import { orderDetailType } from '~/api/interface/orderManageType';
import dayjs from 'dayjs';

// 表格数据类型
type TableType = any;
// 接口返回的类型
type DataType = InterDataType<orderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType;
};

const DetailInformation: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 表格数据
  const [tableData, setTableData] = useState<TableType>([]);
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: '商品',
      dataIndex: 'wareTitle',
      align: 'center',
    },
    {
      title: '单价(元)',
      dataIndex: 'unitPrice',
      align: 'center',
      render: (text) => `￥${text.toLocaleString()}`,
    },
    {
      title: '数量',
      dataIndex: 'wareNum',
      align: 'center',
    },
    {
      title: '订单状态',
      dataIndex: 'waiting',
      align: 'center',
    },
    {
      title: '应收款',
      dataIndex: 'shouldPay',
      align: 'center',
      render: (text) => `￥${text.toLocaleString()}`,
    },
  ];
  useEffect(() => {
    if (!detail) return;
    setTableData([
      {
        id: 1,
        wareTitle: detail?.wareTitle,
        unitPrice: detail?.unitPrice,
        wareNum: detail?.wareNum,
        waiting: detail?.waiting,
        shouldPay: detail?.shouldPay,
      },
    ]);
  }, [detail]);
  return (
    <div className={'detail-information'}>
      <div className={'detail-title'}>订单明细</div>
      <div className={'detail-text'}>
        <span className={'item'}>订单编号：{detail?.orderNo}</span>
        <span className={'item'} style={{ display: 'none' }}>
          合同编号：UAV202334741131
        </span>
        <span className={'item'}>
          订单租期：
          {dayjs(detail?.startDate).format('YYYY-MM-DD')}
          {' ~ '}
          {dayjs(detail?.endDate).format('YYYY-MM-DD')}
        </span>
        <span className={'item'}>创建时间：{detail?.createTime}</span>
      </div>
      <Table
        style={{ margin: '20px auto', width: '90%' }}
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        bordered
        pagination={false}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
      <div className='detail-price'>
        实收款<span className={'num'}>￥ {detail?.actualPay}</span>元
      </div>
    </div>
  );
};

export default DetailInformation;
