import '@wangeditor/editor/dist/css/style.css'; // 引入 css
import React, { useState, useEffect } from 'react';
import { Editor, Toolbar } from '@wangeditor/editor-for-react';
import { IDomEditor, IEditorConfig, IToolbarConfig } from '@wangeditor/editor';
import { message } from 'antd';
import { CommonAPI } from '~/api';

interface PropsType {
  onChange?: (html?: string) => void;
  richTextContent: string | undefined;
  // eslint-disable-next-line react/require-default-props
  isDetail?: boolean; //是否禁用
  height?: number;
  imgSize?: number;
  videoSize?: number;
}
const RichText: React.FC<PropsType> = ({
  onChange,
  richTextContent,
  isDetail,
  height,
  imgSize,
  videoSize,
}) => {
  // editor 实例
  const [editor, setEditor] = useState<IDomEditor | null>(null);

  // 工具栏配置
  const toolbarConfig: Partial<IToolbarConfig> = {};

  // 编辑器配置
  const editorConfig: Partial<IEditorConfig> = {
    // TS 语法
    placeholder: '请输入内容...',
    MENU_CONF: {
      uploadImage: {
        // 自定义上传
        async customUpload(file: File, insertFn: any) {
          if (file.size / 1024 / 1024 > (imgSize || 5)) {
            return message.warning(`上传文件大小最大${imgSize || 5}M`);
          }
          if (!file.type.includes('image/')) {
            return message.warning('文件格式错误');
          }
          const formData = new FormData();
          formData.append('uploadFile', file);
          CommonAPI.uploadOss(formData).then(({ result }) => {
            insertFn(result.filePath);
          });
        },
      },
      uploadVideo: {
        // 自定义上传
        async customUpload(file: File, insertFn: any) {
          if (file.size / 1024 / 1024 > (videoSize || 5)) {
            return message.warning(`上传文件大小最大${videoSize || 5}M`);
          }
          if (!file.type.includes('video/')) {
            return message.warning('文件格式错误');
          }
          const formData = new FormData();
          formData.append('uploadFile', file);
          CommonAPI.uploadOss(formData).then(({ result }) => {
            insertFn(result.filePath);
          });
        },
      },
    },
  };
  //富文本修改
  const richTextChange = (editor: IDomEditor) => {
    if (onChange) {
      onChange(editor.isEmpty() ? '' : editor.getHtml());
    }
  };
  useEffect(() => {
    return () => {
      if (editor == null) return;
      editor.destroy();
      setEditor(null);
    };
  }, [editor]);

  useEffect(() => {
    if (editor) {
      editor?.setHtml(richTextContent || '');
    }
  }, [richTextContent, editor]);

  useEffect(() => {
    if (editor && isDetail) {
      editor.disable();
    }
  }, [isDetail, editor]);

  return (
    <>
      <div style={{ border: '1px solid #ccc', zIndex: 100 }}>
        <Toolbar
          editor={editor}
          defaultConfig={toolbarConfig}
          mode='default'
          style={{ borderBottom: '1px solid #ccc' }}
        />
        <Editor
          defaultConfig={editorConfig}
          onCreated={setEditor}
          onChange={richTextChange}
          mode='default'
          style={{ height: height || 500 + 'px', overflowY: 'hidden' }}
        />
      </div>
    </>
  );
};
export default RichText;
