import { useEffect, useState } from 'react';
import { FddInterfaceAPI } from '~/api';
import { decode } from 'js-base64';

const RealNameAuth = () => {
  const [authUrl, setAuthUrl] = useState<string>('');

  // 获取第三方认证连接
  const getCompanyVerifyUrl = () => {
    FddInterfaceAPI.getCompanyVerifyUrl({ port: 1 }).then(({ result }) => {
      if (result) {
        setAuthUrl(decode(result));
      }
    });
  };

  useEffect(() => {
    getCompanyVerifyUrl();
  }, []);
  return (
    <div className='real-name-auth'>
      <iframe src={authUrl} title='实名认证' style={{ width: '100%', height: '1000px' }} />
    </div>
  );
};
export default RealNameAuth;
