import axios from '../request';
import {
  applyTagDetails,
  approvalApplyTag,
  authDetailType,
  authRemarkType,
  changeUserTagNew,
  changeUserTagType,
  CompanyListTag,
  cooperationListTag,
  deleteApplyTag,
  deleteBusinessCaseType,
  deleteSuggestionType,
  editUserApplyTag,
  editUserApplyTagDetails,
  getBusinessCaseType,
  getListPartnerType,
  getSuggestionType,
  listAppUserCountType,
  listAppUserType,
  listAuthPageType,
  listUserApplyTag,
  listUserRcdType,
  updateBusinessCaseType,
  updateSuggestionType,
  userAccountUpdateType,
} from '~/api/interface/customManageType';

export class CustomManageAPI {
  // 客户列表
  static listAppUser: listAppUserType = (params) =>
    axios.post('/userapp/user-account/listAppUser', params);
  // 加盟列表
  static CompanyListTag: CompanyListTag = (params) =>
    axios.get('/userapp/cooperation/listTag', { params });
  // 客户列表
  static userAccountUpdate: userAccountUpdateType = (params) =>
    axios.post('/userapp/user-account/update', params);
  // 后台设置小程序用户标签
  static changeUserTag: changeUserTagType = (params) =>
    axios.get('/userapp/cooperation/changeUserTag', { params });
  // 后台设置小程序用户标签
  static changeUserTagNew: changeUserTagNew = (params) =>
    axios.post('/userapp/cooperation/changeUserTag', params);
  // 加盟标签列表
  static cooperationListTag: cooperationListTag = (params) =>
    axios.get('/userapp/cooperation/listTag', { params });
  // 后台申请列表
  static listUserApplyTag: listUserApplyTag = (params) =>
    axios.post('/userapp/cooperation/listUserApplyTag', params);
  // 审批详情
  static applyTagDetails: applyTagDetails = (params) =>
    axios.get('/userapp/cooperation/applyTagDetails', { params });
  // 审批
  static approvalApplyTag: approvalApplyTag = (params) =>
    axios.get('/userapp/cooperation/approvalApplyTag', { params });
  // 强制删除
  static deleteApplyTag: deleteApplyTag = (params) =>
    axios.get('/userapp/cooperation/deleteApplyTag', { params });
  // 后台-编辑详情信息
  static editUserApplyTagDetails: editUserApplyTagDetails = (params) =>
    axios.get('/userapp/cooperation/editUserApplyTagDetails', { params });
  // 后台-编辑服务商信息
  static editUserApplyTag: editUserApplyTag = (params) =>
    axios.post('/userapp/cooperation/editUserApplyTag', params);
  // 裂变-邀请列表
  static listUserRcd: listUserRcdType = (data) =>
    axios.post('/userapp/user-account/listUserRcd', data);
  //  客户-实名认证列表
  static getListAuth: listAuthPageType = (data) =>
    axios.post('/userapp/real-name-auth/listPage', data);
  //  客户-实名认证详情
  static getAuthDetail: authDetailType = (params) =>
    axios.get('/userapp/real-name-auth/detail', { params });
  //  客户-实名认证更新备注
  static updateRemark: authRemarkType = (params) =>
    axios.get('/userapp/real-name-auth/updateRemark', { params });
  //   商家列表-数据统计
  static getListAppUserCount: listAppUserCountType = () =>
    axios.get('/userapp/cooperation/getAuditSum');

  // 合伙人列表
  static getListPartner: getListPartnerType = (data) =>
    axios.post('/userapp/Partner/listPartner', data);

  // 后台--添加(修改)后台用户建议
  static updateSuggestion: updateSuggestionType = (params) =>
    axios.post('/userapp/back-user/updateSuggestion', params);
  // 后台--获取后台用户建议
  static getSuggestion: getSuggestionType = (params) =>
    axios.get('/userapp/back-user/getSuggestion', { params });
  // 后台--删除后台用户建议
  static deleteSuggestion: deleteSuggestionType = (params) =>
    axios.get('/userapp/back-user/deleteSuggestion', { params });
  // 后台--获取企业解决方案列表
  static getBusinessCase: getBusinessCaseType = (params) =>
    axios.get('/userapp/back-user/getBusinessCase', { params });
  // 后台--修改企业解决方案列表
  static updateBusinessCase: updateBusinessCaseType = (params) =>
    axios.post('/userapp/back-user/insertBusinessCase', params);
  // 后台--删除企业解决方案列表
  static deleteBusinessCase: deleteBusinessCaseType = (params) =>
    axios.get('/userapp/back-user/deleteBusinessCase', { params });
}
