import React, { FC, useEffect } from 'react';
import { Form, Input, Modal, message, Select, ModalProps } from 'antd';
import { ProduceManageAPI } from '~/api';
import { InterDataType, InterReqType } from '~/api/interface';
import { MakeListType } from '~/api/interface/makeManage';
import { addProductType } from '~/api/interface/produceManageType';
import { filterObjAttr } from '~/utils';

//品牌返回类型
type makeListType = InterDataType<MakeListType>['list'];
//表单类型
type addMakeParameterType = InterReqType<addProductType>;

interface PropsType {
  closed: () => void;
  data: (addMakeParameterType & { id: number; categoriesId: number }) | undefined;
  makeList: makeListType;
  onOk: () => void;
}

const AddOrEditProduceModal: FC<ModalProps & PropsType> = ({
  open,
  closed,
  data,
  makeList,
  onOk,
}) => {
  // 产品类型下拉列表
  // const [productTypeSelectList, setProductTypeSelectList] = useState<categoryType>([]);
  // 表格事件
  const [form] = Form.useForm<addMakeParameterType>();
  // 关闭弹窗
  const handleClosed = async () => {
    form.resetFields();
    closed();
  };
  // 触发表单验证
  const handleSubmit = () => {
    form
      .validateFields()
      .then((values) => {
        const obj: any = { ...data, ...values };
        ProduceManageAPI[!obj.id ? 'addProductSku' : 'editProductSku'](
          filterObjAttr(obj, ['categoriesId']),
        ).then(({ code }) => {
          if (code === '200') {
            message.success('操作成功');
            form.resetFields();
            onOk();
          }
        });
      })
      .catch((err) => {
        message.warning(err.errorFields[0].errors[0]).then();
      });
  };
  //根据目录获取分类
  // const getCategoryListByDirectory = (directoryId: number) => {
  //   CategoryManageAPI.getCategoryList({ pageNo: 1, pageSize: 99999, directoryId, type: 4 }).then(
  //     ({ result }) => {
  //       setProductTypeSelectList(result.list || []);
  //     },
  //   );
  // };
  // componentsDidMounted
  useEffect(() => {
    if (data) {
      // getCategoryListByDirectory(data.directoryId);
      form.setFieldsValue({
        ...data,
      });
    }
  }, [data]);
  return (
    <Modal
      open={open}
      title={data?.id ? '编辑' : '新增'}
      onCancel={handleClosed}
      onOk={handleSubmit}
      destroyOnClose
      width={768}
    >
      <Form
        name='form'
        form={form}
        layout='horizontal'
        labelCol={{ span: 4 }}
        wrapperCol={{ span: 16 }}
      >
        <Form.Item
          name='productName'
          label='产品名称'
          rules={[{ required: true, message: '请输入产品名称' }]}
        >
          <Input placeholder='请输入产品名称' allowClear maxLength={30} />
        </Form.Item>
        <Form.Item label='归属商品'>
          <Select.Option value={1}>商城商品</Select.Option>
          <Select.Option value={2}>租赁商品</Select.Option>
        </Form.Item>
        {/*<Form.Item*/}
        {/*  label='产品目录'*/}
        {/*  name='directoryId'*/}
        {/*  rules={[{ required: true, message: '请选择产品目录' }]}*/}
        {/*>*/}
        {/*  <Select placeholder='请选择产品目录' onChange={decSelectChange}>*/}
        {/*    {decList.map((v: any, index: number) => (*/}
        {/*      <Select.Option value={v.id} key={index}>*/}
        {/*        {v.directoryName}*/}
        {/*      </Select.Option>*/}
        {/*    ))}*/}
        {/*  </Select>*/}
        {/*</Form.Item>*/}
        {/*<Form.Item*/}
        {/*  name='categoryId'*/}
        {/*  label='产品类型'*/}
        {/*  rules={[{ required: true, message: '请选择产品类型' }]}*/}
        {/*>*/}
        {/*  <Select*/}
        {/*    placeholder='请选择产品类型'*/}
        {/*    allowClear*/}
        {/*    showSearch*/}
        {/*    filterOption={(input, option) =>*/}
        {/*      (option!.children as unknown as string).toLowerCase().includes(input.toLowerCase())*/}
        {/*    }*/}
        {/*  >*/}
        {/*    {productTypeSelectList.map((i, j) => (*/}
        {/*      <Option value={i.id} key={j}>*/}
        {/*        {i.classifyName}*/}
        {/*      </Option>*/}
        {/*    ))}*/}
        {/*  </Select>*/}
        {/*</Form.Item>*/}
        <Form.Item
          name='model'
          label='产品型号'
          rules={[{ required: false, message: '请输入产品型号' }]}
        >
          <Input placeholder='请输入产品型号' allowClear maxLength={50} />
        </Form.Item>
        <Form.Item
          name='productBrandId'
          label='产品品牌'
          rules={[{ required: false, message: '请选择产品品牌' }]}
        >
          <Select
            filterOption={(input, option) =>
              (option!.children as unknown as string).toLowerCase().includes(input.toLowerCase())
            }
            showSearch
            placeholder='请选择产品品牌'
          >
            {makeList.map((v) => (
              <Select.Option value={v.id} key={v.id}>
                {v.brandName}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditProduceModal;
