import {
  getSecondDistrictInfo,
  insertBAccountType,
  listBAccountPageType,
  listCompanyAdd,
  listCompanyPage,
  listCompanyRemove,
  listCompanyUpdate,
  removeBAccountType,
  updateBAccountType,
  updatePasswordType,
} from '../interface/systemManageType';
import axios from '../request';

export class SystemManageAPI {
  // 账号-列表
  static listBAccountPage: listBAccountPageType = (params) =>
    axios.post('/userapp/back-user/listBAccountPage', params);

  // 账号-新增
  static insertBAccount: insertBAccountType = (params) =>
    axios.post('/userapp/back-user/insertBAccount', params);

  // 账号-删除
  static removeBAccount: removeBAccountType = (params) =>
    axios.get('/userapp/user-account/removeAppAccount', { params });

  // 账号-修改
  static updateBAccount: updateBAccountType = (params) =>
    axios.post('/userapp/back-user/updateBAccount', params);

  // 账号-修改密码
  static updatePassword: updatePasswordType = (params) =>
    axios.post('/userapp/back-user/updatePassword', params);

  // 单位-列表
  static listCompanyPage: listCompanyPage = (params) =>
    axios.post('/userapp/company/listCompanyPage', params);

  // 单位-新增
  static listCompanyAdd: listCompanyAdd = (params) => axios.post('/userapp/company/add', params);

  // 单位-修改
  static listCompanyUpdate: listCompanyUpdate = (params) =>
    axios.post('/userapp/company/update', params);

  // 单位-删除
  static listCompanyRemove: listCompanyRemove = (params) =>
    axios.get('/userapp/company/remove', { params });

  // 单位-区域
  static getSecondDistrictInfo: getSecondDistrictInfo = (params) =>
    axios.get('/pms/webDevice/getSecondDistrictInfo', { params });
}
