import {
  companyVerifyUrlType,
  downloadContractType,
  signContractType,
  uploadContractType,
  userFddInfoType,
  viewContractType,
} from '~/api/interface/fddInterfaceType';
import axios from '../request';

export class FddInterfaceAPI {
  //   fdd-企业实名认证
  static getCompanyVerifyUrl: companyVerifyUrlType = (params) =>
    axios.get('/userapp/fdd/auth/getCompanyVerifyUrl', { params });
  //   fdd-获取企业实名认证信息
  static getAppUserFddInfo: userFddInfoType = (params) =>
    axios.get('/userapp/fdd/auth/getAppUserFddInfo', { params });
  //   fdd-上传合同
  static uploadContract: uploadContractType = (data) =>
    axios.post('/userapp/fdd/contract/uploadContract', data);
  //   fdd-签署合同
  static signContract: signContractType = (params) =>
    axios.get('/userapp/fdd/contract/stamp', { params });
  //fdd-合同预览
  static viewContract: viewContractType = (params) =>
    axios.get('/userapp/fdd/contract/viewContract', { params });
  //   fdd-合同下载
  static downloadContract: downloadContractType = (params) =>
    axios.get('/userapp/fdd/contract/downloadContract', { params });
}
