import { InterListType, InterReqType } from '~/api/interface';
import { listPcWechatOrderType, platFormCloseOrderType } from '~/api/interface/orderManageType';
import React from 'react';
import { Form, message, Modal, Select } from 'antd';
import { OrderManageAPI } from '~/api';

// 表格数据类型
type TableType = InterListType<listPcWechatOrderType>;
// 请求数据的类型
type ReqType = InterReqType<platFormCloseOrderType>;

// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const OrderClosed: React.FC<propType> = (props) => {
  OrderClosed.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  // 表单钩子
  const [form] = Form.useForm<ReqType>();
  // 关闭弹窗
  const handleCancel = () => {
    form.resetFields();
    closed();
  };
  // 确认事件
  const handleOk = () => {
    form
      .validateFields()
      .then(async (values) => {
        // console.log('确认事件 --->', values);
        await handleSubmit(values);
      })
      .catch((err) => {
        message
          .warning({
            content: err.errorFields[0].errors[0],
          })
          .then();
      });
  };
  // 提交事件
  const handleSubmit = async (values: ReqType) => {
    const res = await OrderManageAPI.platFormCloseOrder({
      ...values,
      orderInfoId: Number(data?.id),
    });
    if (res && res.code === '200') {
      message.success('操作成功');
      handleCancel();
    }
  };
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      onOk={handleOk}
      destroyOnClose
      width={400}
    >
      <Form
        name='addForm'
        form={form}
        labelAlign='right'
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 12 }}
      >
        <Form.Item
          label='关闭理由'
          name='shutReason'
          rules={[{ required: true, message: '请选择关闭理由' }]}
        >
          <Select
            placeholder={'请选择关闭理由'}
            options={[
              { label: '未及时付款' },
              { label: '买家不想买' },
              { label: '买家信息填写错误，重新下单' },
              { label: '恶意买家，同行捣乱' },
              { label: '缺货' },
              { label: '买家拍错了' },
              { label: '其他原因' },
            ].map((i) => ({ label: i.label, value: i.label }))}
            allowClear
          />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default OrderClosed;
