import React, { FC, useState } from 'react';
import { message, Modal, ModalProps, Table, Tag } from 'antd';
import SearchBox from '~/components/search-box';
import { FlyerCenterAPI } from '~/api';
import { ColumnsType } from 'antd/es/table';
import { InterDataType, InterReqType } from '~/api/interface';
import { selectPilotByPhoneType } from '~/api/interface/flyerCenterType';

// 列表的类型
type TableType = InterDataType<selectPilotByPhoneType>[];
// 搜索表单的类型
type ReqType = InterReqType<selectPilotByPhoneType>;
// 参数
interface selfProps {
  data?: any;
}
// 搜索表单的数据
let query: ReqType = {};
const AddFlyerModal: FC<ModalProps & selfProps> = ({ open, onCancel, title }) => {
  // 创建子组件实例
  const SearchBoxRef = React.createRef<any>();
  // 表格数据
  const [tableData, setTableData] = useState<TableType>([]);
  // +++++++++++++++++++++++++++++++++++++++++++++++++++ //
  // 新版通用部分(ES6+ for React) ZhangLK 2022/08/30 Start
  // 加载列表
  const getTableList = async (value = {}) => {
    // 只需要修改这个地方的接口即可
    const res = await FlyerCenterAPI.selectPilotByPhone({
      ...value,
      ...query,
    });
    if (res && res.code === '200') {
      setTableData(res.result ? [res.result] : []);
      // console.log('加载列表 --->', list);
    } else {
      message.warning(res.message);
    }
  };
  // 表单提交
  const onFinish = (data: ReqType) => {
    query = data;
    getTableList(data).then();
  };
  // +++++++++++++++++++++++++++++++++++++++++++++++++++ //
  // 当前选中的项目
  const [selectedRowsList, setSelectedRowsList] = useState<number[]>([]);
  // 关闭弹窗
  const handleCancel = () => {
    setTableData([]);
    SearchBoxRef.current.handleRestForm();
    setSelectedRowsList([]);
    onCancel?.({} as any);
  };
  // 提交数据
  const handleSubmit = async () => {
    if (!selectedRowsList.length) {
      message.warning('请选择飞手').then();
      return;
    }
    // 将选中的数据转换为原始数据
    const list = selectedRowsList.map((i) => tableData.find((v) => v.id === i));
    // 飞手id
    const userAccountId = list?.at(0)?.userAccountId;
    // 提交数据
    const res = await FlyerCenterAPI.insertPilotJoinTeam({
      pilotId: userAccountId,
    });
    if (res && res.code === '200') {
      message.success('添加成功').then();
      handleCancel();
    }
    // console.log('提交数据 --->', userAccountId);
  };
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: 'UID',
      dataIndex: 'userAccountId',
      align: 'center',
    },
    {
      title: '姓名',
      align: 'center',
      dataIndex: 'userName',
    },
    {
      title: '手机号',
      align: 'center',
      dataIndex: 'phoneNum',
    },
    {
      title: '能力认证',
      align: 'center',
      dataIndex: 'pilotAbility',
      width: '20%',
      render: (text) =>
        text ? text.map((v: any) => <Tag key={v.abilityId}>{v.abilityName}</Tag>) : '',
    },
    {
      title: '常驻城市',
      align: 'center',
      dataIndex: 'residentCity',
    },
  ];
  return (
    <Modal open={open} onCancel={handleCancel} title={title} onOk={handleSubmit} width={768}>
      <SearchBox
        search={[
          {
            label: '手机号',
            name: 'phoneNumber',
            type: 'Input',
            placeholder: '请输入飞手的手机号',
          },
        ]}
        searchData={(data: ReqType) => {
          if (!data?.phoneNumber) {
            message.warning('请输入飞手的手机号').then();
            return;
          }
          onFinish(data);
        }}
        isReset={false}
        onRef={SearchBoxRef}
      />
      <Table
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        // scroll={{ x: 1000 }}
        bordered
        rowSelection={{
          type: 'radio',
          selectedRowKeys: selectedRowsList,
          onChange: (_selectedRowKeys: React.Key[], selectedRows: TableType) => {
            setSelectedRowsList(selectedRows.map((i) => i.id));
            // console.log('selectedRows --->', selectedRows);
          },
        }}
      />
    </Modal>
  );
};
export default AddFlyerModal;
