import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';

//飞手列表
type flyerItemType = {
  abilityUrl: string;
  age: number;
  areaNumber: number;
  auditStatus: number;
  createTime: string;
  id: number;
  individualResume: string;
  licenseNumber: number;
  licenseType: string;
  licenseUrl: string;
  phoneNum: number;
  pilotAbility: {
    abilityId: number;
    abilityName: string;
    id: number;
  }[];
  remark: string;
  residentCity: string;
  sex: number;
  timeOfApplication: string;
  updateTime: string;
  userAccountId: number;
  userName: number;
  yearsOfWorking: number;
  reason: string;
};
export type backListPilotType = InterItemFunction<
  {
    abilityId?: number;
    accountNumber?: string;
    areaNumber?: any;
    auditStatus?: number;
    id?: number;
    licenseType?: string;
  },
  flyerItemType[]
>;
//修改备注
export type updateRemarkType = InterFunction<{ id: number; remark: string }, any>;
//能力类型
export type abilityListType = InterFunction<any, { abilityId: number; abilityName: string }[]>;
//飞手认证日志类型
export type backPilotLogListType = InterItemFunction<
  { accountNumber?: string },
  {
    certificationDate: number;
    certificationMessage: number;
    createTime: string;
    id: number;
    operatorUserAccount: number;
    operatorUserId: number;
    operatorUserName: number;
    phoneNum: number;
    updateTime: string;
    userAccountId: number;
    userName: number;
  }[]
>;
//飞手详情
export type backDetailPilotType = InterFunction<{ id: number }, flyerItemType>;
//飞手审批
export type updateAuditStatusType = InterFunction<
  { auditStatus: number; reasonId?: number; id: number },
  any
>;
//飞手审批不通过原因列表
export type backListReasonType = InterFunction<any, { id: number; reason: string }[]>;
// 飞手审批数据统计
export type getPilotAuditSumType = InterFunction<
  any,
  {
    failPilotAuditSum: number;
    passPilotAuditSum: number;
    unAuditedPilotSum: number;
  }
>;

// 后台-根据飞手电话号码查找飞手
export type selectPilotByPhoneType = InterFunction<
  {
    phoneNumber?: string;
  },
  {
    abilityUrl: string;
    age: number;
    areaNumber: number;
    auditStatus: string;
    createTime: string;
    id: number;
    individualResume: string;
    licenseNumber: number;
    licenseType: string;
    licenseUrl: string;
    phoneNum: number;
    pilotAbility: Array<{
      abilityId: number;
      abilityName: string;
      id: number;
    }>;
    pilotStatus: string;
    reason: number;
    reasonId: number;
    remark: string;
    residentCity: string;
    sex: number;
    status: boolean;
    timeOfApplication: string;
    updateTime: string;
    userAccountId: number;
    userImg: string;
    userName: number;
    yearsOfWorking: number;
  }
>;

// 后台-飞手团队添加飞手
export type insertPilotJoinTeamType = InterFunction<{ pilotId?: number }, NonNullable<unknown>>;

// 后台-飞手团队-查找属于飞手团队的飞手
export type selectPilotListByTeamType = InterListFunction<
  {
    backId?: number;
    pilotStatus?: number;
  },
  {
    abilityUrl: string;
    age: number;
    areaNumber: number;
    auditStatus: string;
    createTime: string;
    id: number;
    individualResume: string;
    licenseNumber: number;
    licenseType: string;
    licenseUrl: string;
    phoneNum: number;
    pilotAbility: Array<{
      abilityId: number;
      abilityName: string;
      id: number;
    }>;
    pilotStatus: string;
    reason: number;
    reasonId: number;
    remark: string;
    residentCity: string;
    sex: number;
    status: boolean;
    timeOfApplication: string;
    updateTime: string;
    userAccountId: number;
    userImg: string;
    userName: number;
    yearsOfWorking: number;
  }
>;
// 后台-飞手团队踢飞手
export type deletePilotFromTeamType = InterFunction<{ pilotId: number }, NonNullable<unknown>>;
