import { InterFunction, InterListFunction } from '~/api/interface';
// 账号-列表
export type listBAccountPageType = InterListFunction<
  {
    accountStatus?: number;
    area?: string;
    cityCode?: number;
    districtCode?: number;
    keyword?: string;
    provinceCode?: number;
    rcdCompanyId?: number;
    roleId?: number;
    userIds?: Array<number>;
    userType?: number;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    userImg: string;
    userSex: number;
    email: string;
    source: number;
    accountStatus: number;
    remark: string;
    portType: number;
    createTime: string;
    companyAuthStatus: null;
    cooperationTagId: null;
  }
>;
// 账号-新增
export type insertBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-删除
export type removeBAccountType = InterFunction<
  {
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 账号-修改
export type updateBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-修改密码
export type updatePasswordType = InterFunction<
  {
    accountNo?: string;
    accountStatus?: number;
    alertPwd?: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id?: number;
    passWord?: number;
    phoneNum?: string;
    provinceCode?: number;
    remark?: string;
    userName?: string;
  },
  NonNullable<unknown>
>;
// 单位-列表
export type listCompanyPage = InterListFunction<
  { companyName?: string },
  {
    address: string;
    city: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    district: string;
    fullName: string;
    id: number;
    phoneNum: string;
    province: string;
    remark: string;
  }
>;
// 单位-新增
export type listCompanyAdd = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
  },
  NonNullable<unknown>
>;
// 单位-修改
export type listCompanyUpdate = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
  },
  NonNullable<unknown>
>;
// 单位-地域
export type getSecondDistrictInfo = InterFunction<
  NonNullable<unknown>,
  {
    childInfo: any[];
    id: number;
    name: string;
  }[]
>;
// 单位-删除
export type listCompanyRemove = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
