import { Form, Input, Modal, ModalProps } from 'antd';
import { FC, useEffect } from 'react';
import { useSelector } from 'react-redux';
import { listPurchaseOrderType } from '~/api/interface/orderManageType';
import { InterListType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 采购订单列表返回类型
type procurementOrderType = InterListType<listPurchaseOrderType>[0];
interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  currentOrderItem: procurementOrderType | undefined;
}

const RemarkModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, currentOrderItem }) => {
  const [form] = Form.useForm<{ remark: string }>();
  const { userInfo } = useSelector((state: any) => state.UserInfo);

  const handleCancel = () => {
    onCancel();
  };
  const handleOk = () => {
    form.validateFields().then((value) => {
      if (currentOrderItem) {
        OrderManageAPI[
          userInfo.companyInfoVO.companyType === 0 ? 'setUavPoRemark' : 'setUavPoSellerRemark'
        ]({
          id: currentOrderItem?.id,
          content: value.remark,
        }).then(() => {
          onOk();
          form.resetFields();
        });
      }
    });
  };

  useEffect(() => {
    if (currentOrderItem && open) {
      form.setFieldValue(
        'remark',
        userInfo.companyInfoVO.companyType === 0
          ? currentOrderItem.userRemark || undefined
          : currentOrderItem.sellerRemark || undefined,
      );
    }
  }, [currentOrderItem, open]);

  return (
    <Modal open={open} onCancel={handleCancel} onOk={handleOk} title='备注'>
      <Form form={form}>
        <Form.Item name='remark'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} showCount />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default RemarkModal;
