import React from 'react';
import { Navigate, RouteObject } from 'react-router-dom';
import ErrorPage from '~/pages/common/error';
import LayoutView from '~/components/layout';

const Home = React.lazy(() => import('~/pages/home')); //首页
const JobServices = React.lazy(() => import('~/pages/jobServices')); //工作服务
const Mall = React.lazy(() => import('~/pages/mall')); //产品商城

interface RouteObjectType {
  meta?: {
    id: number;
    hidden?: boolean;
    icon?: any;
    customIcon?: boolean;
    title: string;
  };
}
// 路由数组
export const routerList: Array<RouteObject & RouteObjectType> = [
  {
    path: '*',
    element: <div>404</div>,
    errorElement: <ErrorPage />,
  },
  {
    path: '/',
    element: <LayoutView>{location.hash === '#/' && <Navigate to='/home' />}</LayoutView>,
    errorElement: <ErrorPage />,
    children: [
      {
        path: '/home',
        element: <Home />,
      },
      {
        path: '/jobServices',
        element: <JobServices />,
      },
      {
        path: '/mall',
        element: <Mall />,
      },
    ],
  },
];
