import axios from "../request";
import {
  AddAndEditBonusRuleType,
  AddConvertRuleType,
  BonusRuleListQueryType,
  CalculateOrderBonusVOType,
  CheckUserScoreType,
  DistributeMallOrderBonusType,
  GetOrderInfoByOrderNoType,
  GetScoreListType,
  GetUserScoreDetailsType,
  ListCirculateInfoType,
  ListConvertRuleType,
  ListKBTMallUserType,
  ListMallUserPageType,
  ListProportionObjectType,
  MallUserBySearchKeyType,
  OrderBonusBuildMallType,
  OrderBonusListByOrderIdType,
  OrderBonusListPageType,
  OrderBonusListRuleType,
  OrderScoreReleaseType,
  PointListType,
  RemoveBonusRuleType,
  UpdateMallOrderBonusType,
  UserScoreDetailsListType,
  UserScorePageListType,
} from "../interface/pointManageType";

export class PointManageAPI {
  // 演示规范
  static PointList: PointListType = (params) =>
    axios.post("malluser/muser/listMallUserPage", params);

  // 积分列表-分页
  static UserScorePageList: UserScorePageListType = (params) =>
    axios.post("/uavscore/score/userScorePageList", params);

  // 个人积分明细列表
  static UserScoreDetailsList: UserScoreDetailsListType = (params) =>
    axios.post("/uavscore/score/userScoreDetailsList", params);

  // 个人积分明细--查看单条数据
  static GetUserScoreDetails: GetUserScoreDetailsType = (params) =>
    axios.get("/uavscore/score/getUserScoreDetails", { params });

  // 流通方式列表
  static ListCirculateInfo: ListCirculateInfoType = (params) =>
    axios.get("/uavscore/score/listCirculateInfo", { params });

  // 积分发放
  static OrderScoreRelease: OrderScoreReleaseType = (params) =>
    axios.post("/uavscore/score/orderScoreRelease", params);

  // 兑换规则--条件查询列表
  static ListConvertRule: ListConvertRuleType = (params) =>
    axios.get("/uavscore/score/listConvertRule", { params });

  // 积分发放
  static AddConvertRule: AddConvertRuleType = (params) =>
    axios.post("/uavscore/score/addConvertRule", params);

  // 积分提现审批
  static CheckUserScore: CheckUserScoreType = (params) =>
    axios.get("/uavscore/score/checkUserScore", { params });

  // 获取指定明细列表
  static GetScoreList: GetScoreListType = (params) =>
    axios.get("/uavscore/score/getScoreList", { params });

  // 根据订单编号查询订单
  static GetOrderInfoByOrderNo: GetOrderInfoByOrderNoType = (params) =>
    axios.get("/mallorder/pmorderVerOne/getOrderInfoByOrderNo", { params });

  // 积分管理-分成规则-列表查询
  static BonusRuleListQuery: BonusRuleListQueryType = (params) =>
    axios.get("/uavscore/bonus/bonusRuleListQuery", { params });

  // 积分管理-分成规则-分成对象列表
  static ListProportionObject: ListProportionObjectType = (params) =>
    axios.get("/uavscore/bonus/listProportionObject", { params });

  // 积分管理-分成规则-分成对象新增/编辑
  static AddAndEditBonusRule: AddAndEditBonusRuleType = (params) =>
    axios.post("/uavscore/bonus/addAndEditBonusRule", params);

  // 积分管理-分成规则-分成对象删除
  static RemoveBonusRule: RemoveBonusRuleType = (params) =>
    axios.get("/uavscore/bonus/removeBonusRule", { params });

  // 积分管理-订单分成-获取科比特员工标签的相关用户
  static ListKBTMallUser: ListKBTMallUserType = (params) =>
    axios.get("/malluser/muser/listKBTMallUser", { params });

  // 积分管理-订单分成-订单分成列表
  static OrderBonusListPage: OrderBonusListPageType = (params) =>
    axios.post("/mallorder/orderBonus/listPage", params);

  // 积分管理-订单分成-规则-下拉列表
  static OrderBonusListRule: OrderBonusListRuleType = (params) =>
    axios.get("/uavscore/bonus/listRule", { params });

  // 积分管理-订单分成-订单分成详情
  static OrderBonusListByOrderId: OrderBonusListByOrderIdType = (params) =>
    axios.get("/mallorder/orderBonus/listByOrderId", { params });

  // 积分管理-订单分成-根据规则id、订单id 计算分成对象积分
  static OrderBonusBuildMall: OrderBonusBuildMallType = (params) =>
    axios.get("/mallorder/orderBonus/buildMallOrderBonus", { params });

  // 积分管理-订单分成-无人机城账号管理-分页
  static ListMallUserPage: ListMallUserPageType = (params) =>
    axios.post("/malluser/muser/listMallUserPage", params);

  // 积分管理-订单分成-计算拓展规则分成对象
  static CalculateOrderBonusVO: CalculateOrderBonusVOType = (params) =>
    axios.post("/mallorder/orderBonus/calculateOrderBonusVO", params);

  // 积分管理-订单分成-修改分成对象
  static UpdateMallOrderBonus: UpdateMallOrderBonusType = (params) =>
    axios.post("/mallorder/orderBonus/updateMallOrderBonus", params);

  // 积分管理-订单分成-分页条件查找用户列表
  static MallUserBySearchKey: MallUserBySearchKeyType = (params) =>
    axios.get("/malluser/muser/mallUserBySearchKey", { params });

  // 积分管理-订单分成-发放积分
  static DistributeMallOrderBonus: DistributeMallOrderBonusType = (params) =>
    axios.get("/mallorder/orderBonus/distributeMallOrderBonus", { params });
}
