import {
  InterFunction,
  InterItemFunction,
  InterListFunction,
} from "../interface";

// 演示规范
export type PointListType = InterListFunction<
  // 入参
  {
    id?: number;
    uid?: string;
    wxName?: string;
    phone?: string;
    email?: string;
  },
  // 出参
  {
    id?: number;
    tenantId?: number;
    tenantName?: string;
    userName?: string;
    userAccount?: string;
    appSecretKey?: string;
    createdDate?: string;
    status?: string;
    roleId?: number;
    roleName?: string;
    validityDate?: string;
    customer?: string;
    role?: string;
    organization?: string;
    userUseDetail?: string;
    versionsTermNum?: string;
    versionsTermUnit?: string;
    uid?: string;
    nameAuthentication?: string;
    enterpriseCertification?: string;
    wxName?: string;
    phone?: string;
    email?: string;
  }
>;

// 积分列表分页
export type UserScorePageListType = InterItemFunction<
  { entName?: string; phoneNum?: string; uid?: string },
  {
    convertScore?: number;
    releaseScore?: number;
    userBasicInfo: Array<{
      entName?: string;
      mallUserId?: number;
      phoneNum?: string;
      uid?: string;
      score?: number;
      nickName?: string;
      userName?: string;
    }>;
    withdrawScore?: number;
    withdrawingScore?: number;
  }
>;

// 个人积分明细列表
export type UserScoreDetailsListType = InterItemFunction<
  {
    mallUserId?: number;
  },
  {
    convertScore?: number;
    mallUserId?: number;
    nickName?: string;
    scoreTotal?: number;
    uid?: string;
    useScore?: number;
    userName?: string;
    userScoreList: Array<{
      id?: number;
      convertRatio?: string;
      gainFormUid?: string;
      getTime?: string;
      giveAwayToUid?: string;
      orderNo?: string;
      scoreNum?: number;
      status?: number;
      type?: string;
      useTime?: string;
      withdrawId?: number;
      orderId?: string;
      approvalTime?: string;
    }>;
  }
>;

// 个人积分明细--查看单条数据
export type GetUserScoreDetailsType = InterFunction<
  {
    id: number;
  },
  {
    convertRatio?: string;
    gainFormUid?: string;
    getTime?: string;
    giveAwayToUid?: string;
    orderNo?: string;
    scoreNum?: number;
    status?: number;
    type?: string;
    useTime?: string;
    approvalTime?: string;
  }
>;

// 流通方式列表
export type ListCirculateInfoType = InterFunction<
  {},
  { id: number; type: string }[]
>;

// 积分发放
export type OrderScoreReleaseType = InterFunction<
  {
    circulateId: number;
    mallUserId: number;
    orderNo: string;
    score: number;
    orderId: string;
  },
  {}
>;

// 兑换规则--条件查询列表
export type ListConvertRuleType = InterListFunction<
  { status?: number },
  {
    convertRatio: string;
    entryIntoForceTime: string;
    id: number;
    ruleName: string;
    status: string;
  }
>;

// 新增兑换规则
export type AddConvertRuleType = InterFunction<
  {
    coupon: number;
    entryIntoForceTime?: string;
    ruleName: string;
    score: number;
  },
  {}
>;

// 积分提现审批
export type CheckUserScoreType = InterFunction<
  {
    withdrawDetailsId?: number;
    flag?: boolean;
  },
  {}
>;

// 积分提现审批--查看单条数据
export type GetScoreListType = InterListFunction<
  { type?: number; status?: number },
  {
    mallUserId: number;
    uid: string;
    phoneNum: string;
    entName: string;
    id: number;
    releaseScore: number;
    releaseTime: string;
    convertRuleId: number;
    convertScore: number;
    convertTime: string;
    oldStatus: number;
    pcAccountId: number;
    pcCheckTime: number;
    status: number;
    withdrawScore: number;
    withdrawTime: string;
    score: number;
    coupon: number;
    userName: string;
    nickName: string;
    accountBank: string;
    accountName: string;
    bankCardNumber: string;
    bankCardsId: number;
    branch: string;
  }
>;

// 根据订单编号查询订单
export type GetOrderInfoByOrderNoType = InterFunction<
  { orderNo: string },
  {
    orderNo: string;
    id: number;
  }
>;

// 积分管理-分成规则-列表查询
export type BonusRuleListQueryType = InterListFunction<
  { ruleName?: string },
  {
    bonusSet: Array<{
      id?: number;
      propObjCode?: number;
      proportionMode?: number;
      proportionParam?: number;
    }>;
    defaultRule?: number;
    id?: number;
    proportionObject?: string;
    ruleName: string;
  }
>;

// 积分管理-分成规则-分成对象列表
export type ListProportionObjectType = InterFunction<
  {},
  {
    code: number;
    id: number;
    name: string;
  }[]
>;

// 积分管理-分成规则-分成对象新增/编辑
export type AddAndEditBonusRuleType = InterFunction<
  {
    bonusSetList: Array<{
      id?: number;
      propObjCode?: number;
      proportionMode?: number;
      proportionParam?: number;
    }>;
    defaultRule?: boolean;
    id?: number;
    ruleName?: string;
  },
  any
>;

// 积分管理-分成规则-分成对象删除
export type RemoveBonusRuleType = InterFunction<
  {
    id?: number;
  },
  {}
>;

// 积分管理-订单分成-获取科比特员工标签的相关用户
export type ListKBTMallUserType = InterFunction<
  {
    keyword: string;
  },
  {
    id: number;
    uid: string;
    userName: string;
    phoneNum: string;
    openId: null;
    unionId: null;
    nickName: string;
    headerImg: null;
    lon: null;
    lat: null;
    ports: null;
    remark: null;
    source: null;
    channelAuthStatus: null;
    channelClass: number;
    channelName: string;
    tagName: null;
    createTime: null;
    updateTime: null;
    realAuthStatus: number;
    entAuthStatus: number;
    entName: string;
    entVerifyStatus: null;
    realAuthTime: null;
    entAuthTime: null;
    entVerifyTime: null;
    upReferralId: null;
    upReferralUidAndName: null;
    lowerReferralCount: null;
    operateId: null;
    operateName: null;
    saleId: null;
    saleName: null;
    mallOperator: null;
    mallOperatorName: null;
    mallOperatorUID: null;
    mallSaleManager: null;
    mallSaleManagerUID: null;
    mallSaleManagerName: null;
    superiorChannelName: null;
    accountBank: null;
    accountName: null;
    bankCardNumber: null;
    branch: null;
  }[]
>;

// 积分管理-订单分成-订单分成列表
export type OrderBonusListPageType = InterListFunction<
  {
    divide?: number;
    entName?: string;
    keyword?: string;
    orderNo?: string;
  },
  {
    orderId: string;
    orderNo: string;
    orderName: string;
    realityAmount: number;
    divide: number;
    mallUserId: number;
    uid: string;
    userName: string;
    nickName: null;
    entName: string;
  }
>;

// 积分管理-订单分成-订单分成列表
export type OrderBonusListRuleType = InterFunction<
  {},
  {
    id: number;
    ruleName: string;
    defaultRule: number;
    proportionObject: null;
    bonusSet: null;
  }[]
>;

// 积分管理-订单分成-订单分成详情
export type OrderBonusListByOrderIdType = InterFunction<
  { orderId: number },
  {
    defaultList: Array<{
      checkStatus: number;
      deleted: null;
      createTime: null;
      updateTime: null;
      channelClass: number;
      channelName: string;
      id: number;
      mallUserId: number;
      orderId: number;
      orderNO: string;
      proportionMode: number;
      proportionObjName: string;
      proportionRate: number;
      proportionRuleId: number;
      ruleType: number;
      scoreAmount: number;
      uid: string;
      userName: string;
      index?: number;
    }>;
    extendList: Array<{
      checkStatus: number;
      deleted: null;
      createTime: null;
      updateTime: null;
      channelClass: number;
      channelName: string;
      id: number;
      mallUserId: number;
      orderId: number;
      orderNO: string;
      proportionMode: number;
      proportionObjName: string;
      proportionRate: number;
      proportionRuleId: number;
      ruleType: number;
      scoreAmount: number;
      uid: string;
      userName: string;
      index?: number;
    }>;
    bonusRuleDTO: {
      id: number;
      ruleName: string;
      defaultRule: number;
      proportionObject: null;
      bonusSet: Array<{
        id: number;
        propObjCode: number;
        proportionMode: number;
        proportionParam: null;
      }>;
    };
  }
>;

// 积分管理-订单分成-根据规则id、订单id 计算分成对象积分
export type OrderBonusBuildMallType = InterFunction<
  { orderId: number; proportionRuleId: number },
  {
    checkStatus: number;
    deleted: null;
    createTime: null;
    updateTime: null;
    channelClass: number;
    channelName: string;
    id: number;
    mallUserId: number;
    orderId: number;
    orderNO: string;
    proportionMode: number;
    proportionObjName: string;
    proportionRate: number;
    proportionRuleId: number;
    ruleType: number;
    scoreAmount: number;
    uid: string;
    userName: string;
    index?: number;
  }[]
>;

// 积分管理-订单分成-无人机城账号管理-分页
export type ListMallUserPageType = InterListFunction<
  {
    endTime?: string;
    entAuthStatus?: number;
    entVerifyStatus?: number;
    keyword?: string;
    phoneNum?: string;
    realAuthStatus?: number;
    source?: number;
    startTime?: string;
    userName?: string;
  },
  {
    accountBank: string;
    accountName: string;
    bankCardNumber: string;
    branch: string;
    channelAuthStatus: number;
    channelClass: number;
    createTime: string;
    entAuthStatus: number;
    entAuthTime: string;
    entName: string;
    entVerifyStatus: number;
    entVerifyTime: string;
    headerImg: string;
    id: number;
    lat: number;
    lon: number;
    lowerReferralCount: number;
    mallOperator: number;
    mallOperatorName: string;
    mallOperatorUID: string;
    mallSaleManager: number;
    mallSaleManagerName: string;
    mallSaleManagerUID: string;
    nickName: string;
    openId: string;
    operateId: number;
    operateName: string;
    phoneNum: string;
    ports: string;
    realAuthStatus: number;
    realAuthTime: string;
    remark: string;
    saleId: number;
    saleName: string;
    source: number;
    superiorChannelName: string;
    tagName: string;
    uid: string;
    unionId: string;
    upReferralId: number;
    upReferralUidAndName: string;
    updateTime: string;
    userName: string;
  }
>;

// 积分管理-订单分成-计算拓展规则分成对象
export type CalculateOrderBonusVOType = InterFunction<
  {
    channelClass?: number;
    channelName?: string;
    id?: number;
    mallUserId?: number;
    orderId?: number;
    orderNO?: string;
    proportionMode?: number;
    proportionObjName?: string;
    proportionRate?: number;
    proportionRuleId?: number;
    ruleType?: number;
    scoreAmount?: number;
    uid?: string;
    userName?: string;
  },
  {
    channelClass: number;
    channelName: string;
    id: null;
    mallUserId: number;
    orderId: string;
    orderNO: string;
    proportionMode: number;
    proportionObjName: string;
    proportionRate: number;
    proportionRuleId: null;
    ruleType: null;
    scoreAmount: number;
    uid: null;
    userName: null;
  }
>;

// 积分管理-订单分成-修改分成对象
export type UpdateMallOrderBonusType = InterFunction<
  {
    channelClass: number;
    channelName: string;
    id: number;
    mallUserId: number;
    orderId: number;
    orderNO: string;
    proportionMode: number;
    proportionObjName: string;
    proportionRate: number;
    proportionRuleId: number;
    ruleType: number;
    scoreAmount: number;
    uid: string;
    userName: string;
    index?: number;
  }[],
  {}
>;

// 积分管理-订单分成-修改分成对象
export type MallUserBySearchKeyType = InterListFunction<
  {
    searchKey?: string;
  },
  {
    accountBank: string;
    accountName: string;
    bankCardNumber: string;
    branch: string;
    channelAuthStatus: number;
    channelClass: number;
    createTime: string;
    entAuthStatus: number;
    entAuthTime: string;
    entName: string;
    entVerifyStatus: number;
    entVerifyTime: string;
    headerImg: string;
    id: number;
    lat: number;
    lon: number;
    lowerReferralCount: number;
    mallOperator: number;
    mallOperatorName: string;
    mallOperatorUID: string;
    mallSaleManager: number;
    mallSaleManagerName: string;
    mallSaleManagerUID: string;
    nickName: string;
    openId: string;
    operateId: number;
    operateName: string;
    phoneNum: string;
    ports: string;
    realAuthStatus: number;
    realAuthTime: string;
    remark: string;
    saleId: number;
    saleName: string;
    source: number;
    superiorChannelName: string;
    tagName: string;
    uid: string;
    unionId: string;
    upReferralId: number;
    upReferralUidAndName: string;
    updateTime: string;
    userName: string;
  }
>;

// 积分管理-订单分成-发放积分
export type DistributeMallOrderBonusType = InterFunction<
  { orderId: number },
  {
    bonusRuleDTO: {
      bonusSet: Array<{
        id: number;
        propObjCode: number;
        proportionMode: number;
        proportionParam: number;
      }>;
      defaultRule: number;
      id: number;
      proportionObject: string;
      ruleName: string;
    };
    defaultList: Array<{
      channelClass: number;
      channelName: string;
      checkStatus: number;
      createTime: string;
      deleted: number;
      id: number;
      mallUserId: number;
      orderId: number;
      orderNO: string;
      proportionMode: number;
      proportionObjName: string;
      proportionRate: number;
      proportionRuleId: number;
      ruleType: number;
      scoreAmount: number;
      uid: string;
      updateTime: string;
      userName: string;
    }>;
    extendList: Array<{
      channelClass: number;
      channelName: string;
      checkStatus: number;
      createTime: string;
      deleted: number;
      id: number;
      mallUserId: number;
      orderId: number;
      orderNO: string;
      proportionMode: number;
      proportionObjName: string;
      proportionRate: number;
      proportionRuleId: number;
      ruleType: number;
      scoreAmount: number;
      uid: string;
      updateTime: string;
      userName: string;
    }>;
  }
>;
