import { FC, useEffect, useRef, useState } from 'react';
import { Image, Modal, ModalProps } from 'antd';
import { InterDataType } from '~/api/interface';
import { industryNewsDetailType, industryNewsListType } from '~/api/interface/resourceManageType';
import { ResourceManageAPI } from '~/api';
import './index.scss';

//行业新闻返回类型
type industryNewsType = InterDataType<industryNewsListType>['list'];
//行业新闻详情返回类型
type detailType = InterDataType<industryNewsDetailType>;
interface selfProps {
  currentIndustryNews?: industryNewsType[0];
}

const PreviewNewsModal: FC<ModalProps & selfProps> = ({ open, onCancel, currentIndustryNews }) => {
  const newsContentsRef = useRef<any>();
  //行业新闻详情
  const [industryNewsDetail, setIndustryNewsDetail] = useState<detailType>();
  //获取行业详情
  const getIndustryNewsDetail = (id: number) => {
    ResourceManageAPI.getIndustryNewsDetail({ id }).then(({ result }) => {
      setIndustryNewsDetail(result);
      newsContentsRef.current.innerHTML = result.newsContents;
    });
  };
  useEffect(() => {
    if (currentIndustryNews) {
      getIndustryNewsDetail(currentIndustryNews.id);
    }
  }, [currentIndustryNews]);
  return (
    <Modal open={open} onCancel={onCancel} title='预览' width={800} footer={null}>
      <div className='industry-news-detail'>
        <div className='industry-news-detail-title'>{industryNewsDetail?.newsTitle}</div>
        <div className='industry-news-detail-img'>
          <Image src={industryNewsDetail?.surfaceImg} height={200} width={600} />
        </div>
        <div className='industry-news-detail-content' ref={newsContentsRef}></div>
      </div>
    </Modal>
  );
};
export default PreviewNewsModal;
