import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';

//需求列表
export type listPublishPageType = InterItemFunction<
  { requirementTypeId?: number; keyword?: string },
  {
    id: number;
    publishName: string;
    publishPhone: string;
    requireDescription: string;
    requirementTypeId: number;
    requirementTypeName: string;
  }[]
>;
//需求类型列表
export type requirementsListType = InterFunction<any, { id: number; typeName: string }[]>;

// 查询招标快讯列表-分页
export type releaseTenderNews = InterListFunction<
  {
    endTime?: string;
    startTime?: string;
    tenderName?: string;
    using?: number;
  },
  {
    createTime: Date;
    id: number;
    port: number;
    tenderName: string;
    using: number;
  }
>;
// 新增招标快讯
export type releaseTenderNewsAdd = InterFunction<any, any>;
// 修改招标快讯
export type releaseTenderNewsUpdate = InterFunction<any, any>;
// 删除招标快讯
export type releaseTenderNewsDelete = InterFunction<{ id: number }, any>;

//行业新闻-列表
export type industryNewsListType = InterItemFunction<
  { newsTitle?: string },
  {
    id: number;
    createTime: string;
    newsAuthor: string;
    newsContents: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
  }[]
>;
//行业新闻-新增
export type addIndustryNewsType = InterFunction<
  {
    newsAuthor: string;
    newsContents?: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
  },
  any
>;
//行业新闻-编辑
export type editIndustryNews = InterFunction<
  {
    newsAuthor: string;
    newsContents?: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
    id?: number;
  },
  any
>;
//行业新闻-删除
// export type deleteIndustryNewsType = InterFunction<>;
//行业新闻-详情
export type industryNewsDetailType = InterFunction<
  { id: number },
  {
    id: number;
    createTime: string;
    newsAuthor: string;
    newsContents: string;
    newsTitle: string;
    origin: string;
    surfaceImg: string;
  }
>;
