import axios from '../request';
import {
  getMallOrderDetailById,
  listExpressInfoType,
  listOfRentalOrdersType,
  listPageManagerVerOne,
  listPcWechatOrderType,
  listTranStatusType,
  orderDetailType,
  orderImageDetailType,
  orderListStatus,
  pfConfirmOrderWareType,
  platFormCloseOrderType,
  refundOrderType,
  renterTakeOrderType,
  sendOrderWareType,
  serviceOrderStatusType,
  serviceOrderType,
} from '~/api/interface/orderManageType';

export class OrderManageAPI {
  // web 租赁订单-分页-列表
  static listOfRentalOrders: listOfRentalOrdersType = (params) =>
    axios.post('/oms/RentalOrders/listOfRentalOrders', params);

  // 后台管理 租赁订单-分页-列表
  static listPcWechatOrder: listPcWechatOrderType = (params) =>
    axios.post('/oms/RentalOrders/listPcWechatOrder', params);

  // web/小程序——订单详情
  static orderDetail: orderDetailType = (params) =>
    axios.get('/oms/RentalOrders/orderDetail', { params });

  // 订单状态-字典
  static listTranStatus: listTranStatusType = (params) =>
    axios.get('/oms/RentalOrders/listTranStatus', { params });

  // 后台管理——发货-订单/ 卖家发货
  static sendOrderWare: sendOrderWareType = (params) =>
    axios.post('/oms/RentalOrders/sendOrderWare', params);

  // web/小程序 确认收货-订单
  static renterTakeOrder: renterTakeOrderType = (params) =>
    axios.post('/oms/RentalOrders/renterTakeOrder', params);

  // web/小程序 确认收货-订单
  static pfConfirmOrderWare: pfConfirmOrderWareType = (params) =>
    axios.post('/oms/RentalOrders/pfConfirmOrderWare', params);

  // v1.0.1 物流公司列表-字典
  static listExpressInfo: listExpressInfoType = (params) =>
    axios.get('/oms/express/listExpressInfo', { params });

  // web-小程序——订单详情相关图片信息
  static orderImageDetail: orderImageDetailType = (params) =>
    axios.get('/oms/RentalOrders/orderImageDetail', { params });

  // 后台管理关闭订单
  static platFormCloseOrder: platFormCloseOrderType = (params) =>
    axios.get('/oms/RentalOrders/platFormCloseOrder', { params });

  // 后台管理——驳回/同意退款
  static refundOrder: refundOrderType = (params) => axios.post('/oms/refund/refund', params);

  // 商城订单-订单状态-字典
  static orderListStatus: orderListStatus = (params) =>
    axios.get('/oms/mallorder/listStatus', { params });

  // v1.0.0订单管理-分页查询（改版后）
  static listPageManagerVerOne: listPageManagerVerOne = (params) =>
    axios.post('/oms/pmorderVerOne/listPageManagerVerOne', params);

  // v1.0.0订单管理-详情（改版后）
  static getMallOrderDetailById: getMallOrderDetailById = (params) =>
    axios.get('/oms/pmorderVerOne/getMallOrderDetailById', { params });
  //  服务-订单
  static getServiceOrderList: serviceOrderType = (data) =>
    axios.post('/oms/serviceOrderTask/queryOrderTaskList', data);
  //  服务-订单字典
  static getServiceStatusList: serviceOrderStatusType = () =>
    axios.post('/oms/serviceOrderTask/getServiceOrderStatus');
}
