import { InterFunction, InterListFunction } from '~/api/interface';
// 用户登录
export type BackEndLoginType = InterFunction<
  { accountNo: string; passWord: string; remember?: boolean },
  {
    token: string;
    userAccountId: number;
    accountNo: string;
    portType: null;
    uid: null;
    phoneNum: null;
    userName: null;
    nickName: null;
  }
>;
// 上传图片
export type uploadOssType = InterFunction<any, { filePath: string }>;
// 断电上传
export type uploadOssBPType = InterFunction<any, any>;
// V1.0.1-宣传模块管理-分页
export type listModuleInfoPage = InterListFunction<
  {
    keyword?: string;
    moduleCode?: string;
    moduleType?: number;
    port?: number;
  },
  {
    id: number;
    moduleName: string;
    moduleType: number;
    remark: string;
    deleted: number;
    moduleCode: string;
    createTime: string;
  }
>;
// 修改宣传备注
export type updateModuleInfoRemark = InterFunction<
  {
    id: number;
    remark: string;
  },
  NonNullable<unknown>
>;
// V1.0.1-删除宣传模块
export type removeModuleInfo = InterFunction<{ id: number }, NonNullable<unknown>>;
// V1.0.1-宣传模块-新增
export type insertModuleInfo = InterFunction<
  {
    id?: number;
    moduleCode: string;
    moduleName: string;
    moduleType: number;
    remark?: string;
  },
  NonNullable<unknown>
>;
// 宣传模块-修改
export type updateModuleInfo = InterFunction<
  {
    id: number;
    moduleCode?: string;
    moduleName?: string;
    moduleType?: number;
    remark?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner管理-分页
export type listBannerInfoPage = InterListFunction<
  {
    keyword?: string;
    moduleId?: number;
    moduleType?: number;
  },
  {
    bannerImg: string;
    bannerName: string;
    bannerPoster: string;
    bannerType: number;
    bannerUrl: string;
    createTime: string;
    deleted: number;
    detailInfo: string;
    endTime: string;
    goodsId: number;
    id: number;
    moduleId: number;
    sort: number;
    startTime: string;
    textContent: string;
    using: number;
  }
>;
// // V1.0.1-banner-新增
export type insertBannerInfo = InterFunction<
  {
    bannerImg?: string;
    bannerName?: string;
    bannerPoster?: string;
    bannerType?: number;
    bannerUrl?: string;
    detailInfo?: string;
    endTime?: string;
    goodsId?: number;
    id?: number;
    moduleId?: number;
    sort?: number;
    startTime?: string;
    textContent?: string;
    using?: number;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner-修改
export type updateBannerInfo = InterFunction<
  {
    bannerImg?: string;
    bannerName?: string;
    bannerPoster?: string;
    bannerType?: number;
    bannerUrl?: string;
    detailInfo?: string;
    endTime?: string;
    goodsId?: number;
    id?: number;
    moduleId?: number;
    sort?: number;
    startTime?: string;
    textContent?: string;
    using?: number;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner批量删除
export type batchRemoveBannerInfo = InterFunction<any, NonNullable<unknown>>;
// V1.0.1-删除banner
export type removeBannerInfo = InterFunction<{ id: number }, NonNullable<unknown>>;
// V1.0.1-banner-排序交换
export type exchangeBannerInfo = InterFunction<Array<any>, NonNullable<unknown>>;
