import { FC, useEffect } from 'react';
import { Form, Modal, ModalProps, Input, message } from 'antd';
import { InterListType } from '~/api/interface';
import { mallOrderListType } from '~/api/interface/orderManageType';
import { OrderManageAPI } from '~/api';

type mallOrderType = InterListType<mallOrderListType>[0];
interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  mallOrderItem: mallOrderType | undefined;
}

const RemarkModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, mallOrderItem }) => {
  const [form] = Form.useForm<{ content: string }>();
  const handleOk = () => {
    if (mallOrderItem) {
      form.validateFields().then((value) => {
        OrderManageAPI.sellerRemark({ ...value, id: mallOrderItem.id }).then(({ code }) => {
          if (code === '200') {
            message.success('操作成功');
            onOk();
            form.resetFields();
          }
        });
      });
    }
  };
  const handleCancel = () => {
    form.resetFields();
    onCancel();
  };
  useEffect(() => {
    if (mallOrderItem) {
      form.setFieldValue('content', mallOrderItem.sellerRemark || undefined);
    }
  }, [mallOrderItem]);

  return (
    <Modal open={open} onOk={handleOk} onCancel={handleCancel} title='备注'>
      <Form labelCol={{ span: 2 }} wrapperCol={{ span: 20 }} form={form}>
        <Form.Item label='备注' name='content'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} showCount rows={4} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default RemarkModal;
