import { Form, Image, Input, message, Modal, ModalProps, Table } from 'antd';
import { FC, useState } from 'react';
import { Uploader } from '~/components/uploader';
import { UploadOutlined } from '@ant-design/icons';
import { UploadFile } from 'antd/es/upload/interface';
import { OrderManageAPI } from '~/api';
import { listPurchaseOrderType } from '~/api/interface/orderManageType';
import { InterListType } from '~/api/interface';
import { ColumnsType } from 'antd/es/table/InternalTable';

// 采购订单列表返回类型
type procurementOrderType = InterListType<listPurchaseOrderType>[0];
interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  currentOrderItem: procurementOrderType | undefined;
}
const UploadPayment: FC<ModalProps & selfProps> = ({ open, currentOrderItem, onCancel, onOk }) => {
  const [form] = Form.useForm<{ payImgList: string; payRemark: string }>();
  const [fileList, setFileList] = useState<UploadFile[]>([]);
  const tableColumns: ColumnsType<procurementOrderType['payDTOS'][0]> = [
    {
      title: '序号',
      align: 'center',
      render: (_text: any, _record, index) => index + 1,
    },
    {
      title: '凭证',
      align: 'center',
      dataIndex: 'payImgList',
      render: (text: string) =>
        JSON.parse(text || '[]').map((v: any, index: number) => (
          <Image src={v.filePath} width={50} height={50} key={index} />
        )),
    },
    {
      title: '状态',
      align: 'center',
      dataIndex: 'checkStatus',
      render: (text: number) => (text === 0 ? '审批中' : text === 1 ? '已通过' : '未通过'),
    },
    {
      title: '备注',
      align: 'center',
      width: '10%',
      ellipsis: true,
      dataIndex: 'payRemark',
    },
  ];

  // 上传成功
  const uploadSuccess = (value: any) => {
    setFileList([...value]);
    form.setFieldValue('payImgList', JSON.stringify(value.map((v: any) => ({ filePath: v.url }))));
  };
  const handleOk = () => {
    if (currentOrderItem) {
      form.validateFields().then((values) => {
        OrderManageAPI.uploadPOrder({ ...values, uavOrderId: currentOrderItem.id }).then(
          ({ code }) => {
            if (code === '200') {
              message.success('上传凭证成功'), form.resetFields();
              setFileList([]);
              onOk();
            }
          },
        );
      });
    }
  };
  const handleCancel = () => {
    form.resetFields();
    setFileList([]);
    onCancel();
  };
  return (
    <Modal open={open} onOk={handleOk} onCancel={handleCancel} title='上传付款凭证' width={1000}>
      <Form form={form} labelCol={{ span: 2 }} wrapperCol={{ span: 15 }}>
        <Form.Item
          label='凭证'
          rules={[{ required: true, message: '请上传付款凭证' }]}
          name='payImgList'
        >
          <Uploader
            fileUpload
            listType='picture-card'
            onChange={uploadSuccess}
            fileLength={4}
            defaultFileList={fileList}
          >
            <UploadOutlined />
          </Uploader>
        </Form.Item>
        <Form.Item label='凭证说明' name='payRemark'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} rows={4} showCount />
        </Form.Item>
      </Form>
      {currentOrderItem?.payDTOS?.length ? (
        <Table
          bordered
          columns={tableColumns}
          rowKey='id'
          dataSource={currentOrderItem.payDTOS}
          pagination={false}
        />
      ) : (
        ''
      )}
    </Modal>
  );
};
export default UploadPayment;
