# 项目描述

* **项目名称：** 云享飞官网 & 四端小程序融合 网页端
* **技术栈：** [React 18](https://zh-hans.reactjs.org/docs/getting-started.html) + Hook + TS + Eslint + Prettier + [Antd v5](https://ant.design/components/overview-cn)

- [【gitlab仓库】mmc-store](http://git.mmcuav.cn/root/mmc-store.git)

## 文档

- [Antd 组件库](https://ant.design/components/overview-cn)
- [React 18 中文文档](https://zh-hans.reactjs.org/docs/getting-started.html)
- [TypeScript 中文文档](https://www.tslang.cn/docs/home.html)
- [ESLint + Prettier 配置教程](https://juejin.cn/post/7125207251144409124)
- [vue3+ts+vite项目中使用eslint+prettier指南](https://juejin.cn/post/7118294114734440455)
- [Vite+Vue 3+TS 配置记录](https://juejin.cn/post/7163662410312581150)


## 项目部署

* yarn  
  `yarn ` 安装依赖  
  `yarn dev` 启动本地服务  
  `yarn dev:xx` 启动基于配置文件的本地服务  
  `yarn build` 构建生产包    
  `yarn build:xx` 构建基于配置文件的生产包  
  `yarn lint:fix` eslint全局格式化
* npm & pnpm  
  `npm i` 安装依赖  
  `npm run dev` 启动本地服务  
  `npm run dev:xx` 启动基于配置文件的本地服务  
  `npm run build` 构建生产包  
  `npm run build:xx` 构建基于配置文件的生产包  
  `npm run lint:fix` eslint全局格式化


## 项目结构
```
mmc-store
├── public
└── src
    ├── api                 接口请求
    │   └── modules
    ├── assets              静态文件
    │   ├── css
    │   └── images
    ├── common              公共方法
    │   ├── hook            自定义hook
    │   └── interface       类型接口
    ├── components          自定义组件
    │   ├── layout          
    │   ├── uploader        上传组件封装
    │   └── brandSelectSearch      筛选组件封装
    ├── events              eventBus
    ├── pages     
    │   ├── commom          通用页面（404、登录等）
    │   └── systemSetting   系统管理
    ├── routes              路由
    ├── store               redux
    │   ├── hook
    │   └── slice
    └── utils               工具文件
```
## vscode / webstorm 配置项

* **vscode配置项：**[给 VSCode、Git Hook 配置 ESLint + Prettier 自动格式化](https://zhuanlan.zhihu.com/p/444925446)
* **webstorm 配置项：**[webstorm中vue配置eslint代码格式化](https://juejin.cn/post/7086697887349882894)


## 贡献者

- [ZzzhangLK](https://github.com/ZzzhangLK/)
- [codeghj](https://github.com/codeghj)
