import SearchBox, { searchColumns as searchColumnsType } from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { FlyerCenterAPI } from '~/api';
import { useEffect, useState } from 'react';
import { InterDataType, InterReqListType, PaginationProps } from '~/api/interface';
import { backPilotLogListType } from '~/api/interface/flyerCenterType';
import { useNavigate } from 'react-router-dom';

//日志列表返回类型
type logListType = InterDataType<backPilotLogListType>['list'];
//日志列表请求类型
type logParametersType = InterReqListType<backPilotLogListType>;

const FlyerAuthDaily = () => {
  const navigate = useNavigate();
  const searchColumns: searchColumnsType[] = [
    {
      label: '账号',
      type: 'input',
      placeholder: '请输入UID，姓名或手机号',
      name: 'accountNumber',
    },
  ];
  const tableColumns: ColumnsType<logListType[0]> = [
    {
      title: '审批及认证时间',
      align: 'center',
      dataIndex: 'certificationDate',
    },
    {
      title: '账号',
      align: 'center',
      dataIndex: 'userName',
    },
    {
      title: '手机号',
      align: 'center',
      dataIndex: 'phoneNum',
    },
    {
      title: '申请及审批信息',
      align: 'center',
      dataIndex: 'certificationMessage',
    },
    {
      title: '操作人员',
      align: 'center',
      dataIndex: 'operatorUserName',
    },
  ];
  const [tableData, setTableData] = useState<logListType>([]);
  const [pagination, setPagination] = useState<PaginationProps & { totalCount: number }>({
    pageNo: 1,
    pageSize: 10,
    totalCount: 0,
  });
  const [query, setQuery] = useState<logParametersType>();

  //认证日志列表
  const getBackPilotLogList = (query?: logParametersType) => {
    FlyerCenterAPI.getBackPilotLogList({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
      ...query,
    }).then(({ result }) => {
      pagination.totalCount = result.totalCount;
      setPagination(pagination);
      setTableData(result.list || []);
    });
  };

  //分页
  const paginationChange = (pageNo: number, pageSize: number) => {
    pagination.pageNo = pageNo;
    pagination.pageSize = pageSize;
    getBackPilotLogList(query);
  };
  //筛选成功
  const searchSuccess = (value: logParametersType) => {
    pagination.pageNo = 1;
    pagination.pageSize = 10;
    setQuery(value);
    getBackPilotLogList(value);
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };

  useEffect(() => {
    getBackPilotLogList();
  }, []);

  return (
    <div className='flyer-auth-daily'>
      <SearchBox
        search={searchColumns}
        searchData={searchSuccess}
        otherChild={
          <Button type='primary' onClick={backRoute}>
            返回
          </Button>
        }
      />
      <Table
        columns={tableColumns}
        dataSource={tableData}
        pagination={{
          total: pagination.totalCount,
          pageSize: pagination.pageSize,
          current: pagination.pageNo,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
      />
    </div>
  );
};
export default FlyerAuthDaily;
