import { Button, Table } from 'antd';
import { ArrowDownOutlined, ArrowUpOutlined, PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';

const ServiceCategoryList = () => {
  const tableColumns: ColumnsType<any> = [
    {
      title: '分类名称',
      align: 'center',
    },
    {
      title: '图片',
      align: 'center',
    },
    {
      title: '描述',
      align: 'center',
    },
    {
      title: '创建时间',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
    },
  ];

  return (
    <div className='service-category-list'>
      <div className='list-operate' style={{ marginBottom: '10px' }}>
        <Button type='primary' icon={<PlusOutlined />} style={{ marginRight: '10px' }}>
          新增分类
        </Button>
        <Button icon={<ArrowUpOutlined />} style={{ marginRight: '10px' }} type='primary'></Button>
        <Button icon={<ArrowDownOutlined />} type='primary'></Button>
      </div>
      <Table columns={tableColumns} bordered />
    </div>
  );
};
export default ServiceCategoryList;
