import './index.scss';
import RichText from '~/components/richText';
import { FC } from 'react';
import { InterDataType } from '~/api/interface';
import { detailGoodsType } from '~/api/interface/goodsType';
//商品返回类型
type goodsDetailType = InterDataType<detailGoodsType>;

interface selfProps {
  getRichText: (html?: string) => void;
  goodsDetail: goodsDetailType | undefined;
  isDetail: boolean;
}

const GoodsIntroduce: FC<selfProps> = ({ getRichText, goodsDetail, isDetail }) => {
  const richTextChange = (html?: string) => {
    getRichText(html);
  };
  return (
    <div className='goods-introduce'>
      <div className='goods-introduce-title'>产品介绍图</div>
      <div className='goods-introduce-content'>
        <RichText
          richTextContent={goodsDetail?.goodsDetail.content}
          onChange={richTextChange}
          isDetail={isDetail}
        />
      </div>
    </div>
  );
};
export default GoodsIntroduce;
