import React, { useEffect, useState } from 'react';
import { Image } from 'antd';
import { orderDetailType, orderImageDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<orderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType;
};
// 列表的类型
type ListType = InterDataType<orderImageDetailType>;
// 设备状态列表
const vcuSatusList = [
  { label: '正常', value: 0 },
  { label: '故障', value: 1 },
];
// 0:发货 1:收货 2:归还 3:平台收货
const vcuTypeList = [
  { label: '发货验收', value: 0 },
  { label: '收货验收', value: 1 },
  { label: '归还验收', value: 2 },
  { label: '平台收货', value: 3 },
  { label: '退货申请', value: 4 },
];
const DetailDelivery: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 验收信息列表
  const [orderImageList, setOrderImageList] = useState<ListType>([]);
  // 获取订单验收信息
  const getOrderImageDetail = async () => {
    const res = await OrderManageAPI.orderImageDetail({ orderInfoId: detail?.id });
    if (res && res.code === '200') {
      setOrderImageList(res.result);
      console.log('获取订单验收信息 --->', res.result);
    }
  };
  // 转换设备状态
  const getVcuSatus = (code: number) => {
    return vcuSatusList.find((item) => item.value === code)?.label || code;
  };
  // 转换标题
  const getVcuType = (code: number) => {
    return vcuTypeList.find((item) => item.value === code)?.label || code;
  };
  // componentDidMount
  useEffect(() => {
    if (!detail) return;
    getOrderImageDetail().then();
  }, [detail]);
  return (
    <div className={'detail-delivery detail-half'}>
      {orderImageList.map((i, j) => (
        <div key={j}>
          <div className={'detail-title'}>{getVcuType(i.vcuType)}</div>
          <div className={'detail-text'}>验收状态：{getVcuSatus(i.vcuSatus)}</div>
          <div className={'detail-text'}>验收描述：{i.remark || '无'}</div>
          <div className={'detail-text'}>验收凭证：</div>
          <div className={'detail-image'}>
            {i.imgs?.map((i, j) => (
              <Image key={j} className={'image'} src={i} alt='付款凭证' />
            ))}
            {!i.imgs && <div style={{ height: '30px' }}></div>}
          </div>
        </div>
      ))}
    </div>
  );
};

export default DetailDelivery;
