import { Button, Checkbox, Form, Input, message } from 'antd';
import { useEffect } from 'react';
import { LockOutlined, UserOutlined } from '@ant-design/icons';
import { useNavigate } from 'react-router-dom';
import Cookies from 'js-cookie';
import './index.scss';
import { InterReqType } from '~/api/interface';
import { BackEndLoginType } from '~/api/interface/commonType';
import { CommonAPI, SystemManageAPI } from '~/api';
import { useDispatch } from 'react-redux';
import { SET_USERINFO } from '~/store/module/userInfo';
import { authRouterList } from '~/router';

// 请求的类型
type ReqType = InterReqType<BackEndLoginType>;

function LoginView() {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars,@typescript-eslint/ban-ts-comment
  // @ts-ignore
  const navigate = useNavigate();
  // redux
  const dispatch = useDispatch();
  // 表单钩子
  const [form] = Form.useForm<ReqType>();
  // 提交数据
  const onFinish = async (values: ReqType) => {
    const res = await CommonAPI.BackEndLogin({
      accountNo: values?.accountNo,
      passWord: values?.passWord,
    });
    if (res && res.code === '200') {
      const { token } = res.result;
      await Cookies.set('SHAREFLY-TOKEN', token);
      // 记住密码
      Cookies.set('password', values?.passWord || '');
      Cookies.set('username', values?.accountNo || '');
      Cookies.set('remember', String(values?.remember));
      // 存用户信息
      dispatch(SET_USERINFO(res.result));
      SystemManageAPI.getListRoleMenuInfo({ roleId: res.result.roleInfo.id }).then(({ result }) => {
        localStorage.setItem('roleObj', JSON.stringify(result));
        const routeList = authRouterList();
        // 获取第一个路由
        navigate({ pathname: routeList[0]?.children?.[0]?.path });
      });
    } else {
      message.error('登录失败，请检查账号信息');
    }
  };

  // componentDidMount
  useEffect(() => {
    // 是否保存密码
    const remember = Boolean(Cookies.get('remember'));
    if (!remember) return;
    // 如果保存了密码
    form.setFieldsValue({
      accountNo: Cookies.get('username'),
      passWord: Cookies.get('password'),
      remember: Boolean(Cookies.get('remember')),
    });
  }, []);
  return (
    <div className='login-warp'>
      <div className='login-view'>
        <div className='login-flex login-content'>
          <div className='login-title'>欢迎来到</div>
          <div className='login-text'>科比特 · 云享飞管理平台</div>
          <div className='login-detail'>让天空为世界所用</div>
        </div>
        <div className='login-flex login-form'>
          <div className='login-image' />
          <div className='login-input'>
            <Form
              name='basic'
              form={form}
              wrapperCol={{ span: 16, offset: 4 }}
              initialValues={{ remember: true }}
              onFinish={onFinish}
              autoComplete='off'
            >
              <Form.Item name='accountNo' rules={[{ required: true, message: '请输入用户名' }]}>
                <Input size='large' prefix={<UserOutlined />} placeholder='请输入账号' allowClear />
              </Form.Item>

              <Form.Item
                name='passWord'
                className='login-password'
                rules={[{ required: true, message: '请输入密码' }]}
              >
                <Input.Password
                  size='large'
                  prefix={<LockOutlined />}
                  placeholder='请输入密码'
                  allowClear
                />
              </Form.Item>

              <Form.Item
                name='remember'
                className='login-remember'
                valuePropName='checked'
                wrapperCol={{ offset: 4, span: 8 }}
              >
                <Checkbox>记住密码</Checkbox>
              </Form.Item>

              <Form.Item wrapperCol={{ offset: 7, span: 15 }}>
                <Button
                  type='primary'
                  htmlType='submit'
                  shape='round'
                  size='large'
                  className='login-submit'
                >
                  登录
                </Button>
              </Form.Item>
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
}

export default LoginView;
