import './index.scss';
import dataDashboardsHeaderImg from '~/assets/image/data-dashboards-header.png';
import dataDashboardsLogoImg from '~/assets/image/data-dashboards-logo.png';
import UserInfo from './components/userInfo';
import TradeInfo from './components/tradeInfo';
import JoinInfo from './components/joinInfo';
import { authRouterList } from '~/router';
import { useNavigate } from 'react-router-dom';

const DataDashboards = () => {
  const navigate = useNavigate();
  // 跳转后台
  const toBackEndRoute = () => {
    authRouterList().then((value) => {
      navigate({
        pathname: value[1].children?.find((v: any) => !v.meta.hidden)?.path || value[1].path,
      });
    });
  };
  return (
    <div className='data-dashboards'>
      <div className='data-dashboards-header'>
        <img src={dataDashboardsHeaderImg} alt='' />
      </div>
      <div className='data-dashboards-operate' onClick={toBackEndRoute}>
        <img src={dataDashboardsLogoImg} alt='' />
        <span>进入后台</span>
      </div>
      <div className='data-dashboards-content'>
        <div className='content-card'>
          <UserInfo />
          <TradeInfo />
          <JoinInfo />
        </div>
      </div>
    </div>
  );
};
export default DataDashboards;
