import {
  activeTableItemType,
  activityDataType,
  activityDeleteType,
  activityEditType,
  activityInsertType,
  activityInviteDetailType,
  activityUpdateType,
  addActivityType,
  DataInfoType,
  endActivityType,
  listActivityPagesType,
  SignInListType,
  splitCouponDownType,
} from '../interface/activityManage';
import axios from '../request';

export class ActivityManageAPI {
  // 活动-裂变优惠券-下拉
  static getActivityCouponPullDown: splitCouponDownType = (params) => {
    return axios.get('userpay/coupon/back/getActivityCouponPullDown', {
      params,
    });
  };

  // 活动-新增
  static createActivity: addActivityType = (data) => {
    return axios.post('malluser/activity/create', data);
  };

  // 活动-编辑
  static editActivity: activityEditType = (data) => {
    return axios.post('malluser/activity/update', data);
  };

  // 活动-列表
  static getActivityList: activeTableItemType = (params) => {
    return axios.get('malluser/activity/list', { params });
  };

  //  活动-结束
  static endActivity: endActivityType = (params) => {
    return axios.get('malluser/activity/stop', { params });
  };

  //  活动-数据
  static getActivityData: activityDataType = (params) => {
    return axios.get('malluser/activity/dataInfo', { params });
  };

  // 活动后台——签到调整
  static DataInfo: DataInfoType = (params) => {
    return axios.post('/userapp/insertSignIn', params);
  };
  // 小程序签到列表
  static SignInList: SignInListType = (params) => axios.get('/userapp/SignInList', { params });

  // 活动列表
  static listActivityPages: listActivityPagesType = (params) => {
    return axios.post('/userapp/activity/listActivityPages', params);
  };

  // 添加活动
  static activityInsert: activityInsertType = (params) => {
    return axios.post('/userapp/activity/insert', params);
  };

  // 修改活动
  static activityUpdate: activityUpdateType = (params) => {
    return axios.post('/userapp/activity/update', params);
  };

  // 删除活动
  static activityDelete: activityDeleteType = (params) => {
    return axios.get('/userapp/activity/delete', { params });
  };

  // 活动详情
  static activityInviteDetail: activityInviteDetailType = (params) => {
    return axios.post('/userapp/activity/inviteDetail', params);
  };
}
