import { useEffect, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailDelivery from '~/pages/orderManage/productOrder/comp/detailDelivery';
import DetailPurchaser from '~/pages/orderManage/productOrder/comp/detailPurchaser';
import DetailInformation from '~/pages/orderManage/productOrder/comp/detailInformation';
import { OrderManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { orderDetailType } from '~/api/interface/orderManageType';
import DetailTimeLine from '~/pages/orderManage/equipmentOrder/comp/detailTimeLine';
// import DetailMessageBox from '~/pages/orderManage/equipmentOrder/comp/detailMessageBox';

// 接口返回的类型
type DataType = InterDataType<orderDetailType>;

function EquipmentOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 接收到的参数
  const orderNo = searchParams.get('orderNo') as string;
  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DataType>(null!);
  // 获取订单详情
  const getOrderDetail = async () => {
    const res = await OrderManageAPI.orderDetail({
      orderNo: orderNo,
    });
    if (res && res.code === '200') {
      setOrderDetail(res.result);
      // console.log('获取订单详情 --->', res.result);
    }
  };
  // componentDidMount
  useEffect(() => {
    getOrderDetail().then();
  }, [orderNo]);
  return (
    <div className={'order-detail'}>
      <div className={'order-head'}>
        <div className='head-text'>
          <div>
            <span>订单编号：{orderDetail?.orderNo}</span>
            <span style={{ display: 'none' }}>合同编号：UAV202334741131</span>
          </div>
          <div>
            <span>当前状态：{orderDetail?.waiting}</span>
            <span>创建时间：{orderDetail?.createTime}</span>
          </div>
        </div>
        <Button type={'primary'} onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className={'detail-wrap'}>
        <DetailPurchaser detail={orderDetail} />
        <DetailDelivery detail={orderDetail} />
        <DetailTimeLine detail={orderDetail} />
        {/*<DetailMessageBox />*/}
        <DetailInformation detail={orderDetail} />
      </div>
    </div>
  );
}

export default EquipmentOrderDetail;
