import { useSearchParams } from 'react-router-dom';
import { ResourceManageAPI } from '~/api';
import { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { backDetailPublishType } from '~/api/interface/resourceManageType';
import { Button, Descriptions, Image } from 'antd';
import { useNavigate } from 'react-router-dom';

//需求详情返回类型
type detailType = InterDataType<backDetailPublishType>;
const GatherDetail = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();
  const [publishDetails, setPublishDetails] = useState<detailType>();

  const getPublishDetail = (id: number) => {
    ResourceManageAPI.getDetailPublish({ id }).then(({ result }) => {
      setPublishDetails(result);
    });
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };

  useEffect(() => {
    getPublishDetail(Number(searchParams.get('id')));
  }, []);

  return (
    <div className='gather-detail'>
      <Descriptions
        title='需求信息'
        bordered
        extra={
          <Button type='primary' onClick={backRoute}>
            返回
          </Button>
        }
      >
        <Descriptions.Item label='需求类型'>
          {publishDetails?.requirementTypeName}
        </Descriptions.Item>
        <Descriptions.Item label='任务标题'>{publishDetails?.taskTitle}</Descriptions.Item>
        <Descriptions.Item label='任务地址'>{publishDetails?.taskAddress}</Descriptions.Item>
        <Descriptions.Item label='任务开始时间'>{publishDetails?.taskStartTime}</Descriptions.Item>
        <Descriptions.Item label='任务结束时间'>{publishDetails?.taskEndTime}</Descriptions.Item>
        <Descriptions.Item label='需求描述'>{publishDetails?.requireDescription}</Descriptions.Item>
        <Descriptions.Item label='描述图片'>
          <Image.PreviewGroup>
            {publishDetails?.requireUrl
              ? JSON.parse(publishDetails?.requireUrl).map((url: string, index: number) => (
                  <Image src={url} width={50} key={index} />
                ))
              : ''}
          </Image.PreviewGroup>
        </Descriptions.Item>
      </Descriptions>
    </div>
  );
};
export default GatherDetail;
