import { InterFunction, InterItemFunction } from '~/api/interface';

export type MakeListType = InterItemFunction<
  any,
  {
    createTime: string;
    brandName: string;
    id: number;
  }[]
>;
//产品-列表
export type productListType = InterItemFunction<
  { categoryId?: number; directoryId?: number; productName?: string },
  {
    id: number;
    productName: string;
    productBrandId: number;
    productBrand: string;
    model: string;
    categoriesId: number;
    categoryName: string;
    directoryId: number;
    directoryName: string;
    productSpecList: {
      id: number;
      partNo: string;
      specImage: string;
      specName: string;
      versionDesc: string;
      productSkuId: number;
    }[];
  }[]
>;
//产品-新增
export type addProductType = InterFunction<
  {
    categoryId: number;
    directoryId: number;
    model: string;
    productBrandId: number;
    productName: string;
  },
  null
>;
//产品-编辑
export type editProductType = InterFunction<
  {
    categoryId: number;
    directoryId: number;
    model: string;
    productBrandId: number;
    productName: string;
    id?: number;
  },
  any
>;
//产品-删除
export type deleteProductType = InterFunction<{ id: number }, null>;
//产品-详情
export type productDetailType = InterFunction<
  { id: number },
  {
    id: number;
    productName: string;
    productBrandId: number;
    productBrand: string;
    model: string;
    categoriesId: number;
    categoryName: string;
    directoryId: number;
    directoryName: string;
    productSpecList: {
      id: number;
      partNo: string;
      specImage: string;
      specName: string;
      versionDesc: string;
      productSkuId: number;
    }[];
  }
>;
//产品-规格-列表
export type ProductSpecListType = InterItemFunction<
  { productSkuId: number },
  {
    id: number;
    partNo: string;
    specImage: string;
    specName: string;
    versionDesc: string;
    productSkuId: number;
    priceList: any;
  }[]
>;
//产品-规格-新增
export type productSpecAddType = InterFunction<
  {
    partNo: string;
    productSkuId: number;
    specImage: string;
    specName: string;
    versionDesc: string;
  },
  null
>;
//产品-规格-编辑
export type productSpecEditType = InterFunction<
  {
    partNo: string;
    productSkuId: number;
    specImage: string;
    specName: string;
    versionDesc: string;
    id?: number;
  },
  null
>;
//产品-规格-删除
export type productSpecDeleteType = InterFunction<{ id: number }, any>;
//产品-规格-配置价格
export type productSpecPriceType = InterFunction<
  {
    leaseTerm?: number;
    productSpecId?: number;
    specPrice: { cooperationTag: number; price: number }[];
    type: number;
  },
  null
>;
//产品-规格-获取配置价格
export type getProductSpecPriceType = InterFunction<
  { leaseTerm?: number; productSpecId?: number; type: number },
  { id: number; cooperationTag: number; price: number; leaseTerm: number }[]
>;
//产品-规格-配置价格修改
export type editProductSpecPriceType = InterFunction<
  {
    leaseTerm?: number;
    productSpecId?: number;
    specPrice: { cooperationTag: number; price: number }[];
    type: number;
  },
  null
>;
//加盟标签-列表
export type cooperationTagType = InterFunction<any, { id: number; tagName: string }[]>;
