import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';
import tsconfigPaths from 'vite-tsconfig-paths';
import { resolve } from 'path';

// https://vitejs.dev/config/
export default defineConfig({
  base: './',
  plugins: [react(), tsconfigPaths()],
  server: {
    host: '0.0.0.0',
  },
  envDir: resolve(__dirname, 'env'),
  resolve: {
    // 配置别名
    alias: {
      '@': resolve(__dirname, 'src'),
    },
  },
});
