// 是否允许操作
const isAllowOption = (record: any) => {
  const userInfo = JSON.parse(localStorage.getItem("user_info") as string);
  return (
    userInfo.userAccountId === record.operationId ||
    (userInfo.roleInfo.pmc &&
      (record.statusCode === 710 || record.statusCode === 500))
  );
};
// 设置状态
export const setStatus = (record: any, deliverBtn: boolean) => {
  if (record.statusCode !== 50 && !isAllowOption(record)) {
    return "";
  }
  // 新版
  if (record.statusCode === 200) {
    return record.signStatus === 2 ? "合同签署" : "";
  }
  switch (record.statusCode) {
    case 50:
      return JSON.parse(localStorage.getItem("user_info") as string).roleInfo
        .admin
        ? "分配订单"
        : "";

    case 100:
      return "确认订单";
    case 300:
      return "确认付款";
    case 400:
      return "确认库存";
    case 710:
    case 500:
      return deliverBtn ? "发货" : "";
    case 660:
      return "确认尾款";
    default:
      return null;
  }
};
