import React from 'react';
import { Navigate, RouteObject } from 'react-router-dom';
import ErrorPage from '~/pages/common/error';
import LayoutView from '~/components/layout';
import { AccountBookOutlined, MacCommandOutlined } from '@ant-design/icons';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore
import { AgnosticIndexRouteObject } from '@remix-run/router';
import { Spin } from 'antd';
import { PointList } from '~/pages/pointManage/pointList';
import { PointDetail } from '~/pages/pointManage/pointList/detail';
import { PointRules } from '~/pages/pointManage/pointRules';
import PointDetailList from '~/pages/pointManage/pointDetail';
import DivideOrder from '~/pages/pointManage/divideOrder';
import DivideRules from '~/pages/pointManage/divideRules';

const ProductOrderView = React.lazy(() => import('src/pages/orderManage/productOrder')); //销售订单
const EquipmentOrderView = React.lazy(() => import('src/pages/orderManage/equipmentOrder')); //设备订单
const ServiceOrderView = React.lazy(() => import('src/pages/orderManage/serviceOrder')); //服务订单

export interface RouteObjectType {
  path: AgnosticIndexRouteObject['path'];
  element: any;
  errorElement?: React.ReactNode | null;
  children?: Array<RouteObject & RouteObjectType>;
  meta: {
    id: number;
    hidden?: boolean;
    icon: any;
    customIcon?: boolean;
    title: string;
  };
}

const withLoadingComponent = (comp: JSX.Element) => (
  <React.Suspense
    fallback={
      <Spin size='large' tip='Loading...'>
        <div style={{ width: '100%', height: '50vh', marginTop: '10vh' }}></div>
      </Spin>
    }
  >
    {comp}
  </React.Suspense>
);

// 路由数组
export const routerList: Array<RouteObjectType> = [
  {
    path: '/orderManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 10000,
      icon: <MacCommandOutlined />,
      title: '订单管理',
    },
    children: [
      {
        path: '/orderManage/productOrder',
        element: withLoadingComponent(<ProductOrderView />),
        meta: {
          id: 10010,
          title: '销售订单',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/orderManage/equipmentOrder',
        element: withLoadingComponent(<EquipmentOrderView />),
        meta: {
          id: 10020,
          title: '设备订单',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/orderManage/serviceOrder',
        element: withLoadingComponent(<ServiceOrderView />),
        meta: {
          id: 10030,
          title: '服务订单',
          icon: <MacCommandOutlined />,
        },
      },
    ],
  },
  {
    path: '/pointManage',
    element: <LayoutView />,
    errorElement: <ErrorPage />,
    meta: {
      id: 25000,
      icon: <AccountBookOutlined />,
      title: '积分管理',
    },
    children: [
      {
        path: '/pointManage/pointList',
        element: withLoadingComponent(<PointList />),
        meta: {
          id: 25100,
          title: '积分列表',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/pointList/detail',
        element: withLoadingComponent(<PointDetail />),
        meta: {
          id: 25100,
          title: '个人积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pointManage/pointRule',
        element: withLoadingComponent(<PointRules />),
        meta: {
          id: 25200,
          title: '兑换规则',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/pointList/list',
        element: withLoadingComponent(<PointDetailList />),
        meta: {
          id: 25100,
          title: '积分明细',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
      {
        path: '/pointManage/divideOrder',
        element: withLoadingComponent(<DivideOrder />),
        meta: {
          id: 25300,
          title: '订单分成',
          icon: <MacCommandOutlined />,
        },
      },
      {
        path: '/pointManage/divideRules',
        element: withLoadingComponent(<DivideRules />),
        meta: {
          id: 25400,
          title: '分成规则',
          icon: <MacCommandOutlined />,
          hidden: true,
        },
      },
    ],
  },
];
// 路由白名单
export const whiteRouterList: Array<RouteObject & RouteObjectType> = [
  {
    path: '/',
    element: <Navigate to='/orderManage/productOrder' />,
    meta: {
      id: 0,
      title: '销售订单',
      icon: MacCommandOutlined,
    },
  },
];
// 整合路由数据
export const routes = [...routerList, ...whiteRouterList];
