import React, { useEffect, useState } from "react";
import { Descriptions, Modal } from "antd";
import {
  GetUserScoreDetailsType,
  UserScoreDetailsListType,
} from "@/api/interface/pointManageType";
import { PointManageAPI } from "@/api";

// 列表的类型
type TableType = (ReturnType<UserScoreDetailsListType> extends Promise<infer T>
  ? T
  : never)["result"]["list"]["userScoreList"];
type DetailType = (ReturnType<GetUserScoreDetailsType> extends Promise<infer T>
  ? T
  : never)["result"];
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const contentStyle = { width: "180px" };
// 状态
const statusList = [
  { value: 0, label: "提现中" },
  { value: 1, label: "提现成功" },
  { value: 2, label: "提现失败" },
];

export const DetailModal: React.FC<propType> = (props) => {
  DetailModal.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  // 用户数据
  const [detailData, setDetailData] = useState<DetailType>();
  // 关闭弹窗
  const handleCancel = () => {
    closed();
  };
  // 状态转换
  const transStatus = (id: number) => {
    return statusList.find((i) => i.value === id)?.label || id;
  };
  // 获取详情数据
  const getUserScoreDetails = async () => {
    const res = await PointManageAPI.GetUserScoreDetails({
      id: Number(data?.id),
    });
    if (res && res.code === "200") {
      setDetailData(res.result);
      // console.log(res.result);
    }
  };
  // 获取使用时间
  const getUseTime = (record: DetailType) => {
    if (detailData?.type === "积分提现" && detailData?.status === 0) {
      return "";
    }
    if (detailData?.type === "积分提现" && detailData?.status === 2) {
      return "";
    }
    if (detailData?.type === "积分提现" && detailData?.status === 1) {
      return record?.approvalTime;
    }
    return record?.useTime;
  };
  // 获取申请提现时间
  const getApplyTime = (record: DetailType) => {
    if (detailData?.type === "积分提现" && detailData?.status === 0) {
      return record?.useTime;
    }
    if (["积分转赠", "积分兑换"].includes(detailData?.type || "")) {
      return "";
    }
    return record?.useTime;
  };
  useEffect(() => {
    if (!data) return;
    (async () => {
      await getUserScoreDetails();
    })();
  }, [data]);
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      footer={null}
      destroyOnClose
      width={650}
    >
      <Descriptions column={2} bordered size="small">
        <Descriptions.Item contentStyle={contentStyle} label="积分数值">
          {detailData?.scoreNum &&
            (detailData?.scoreNum > 0
              ? `+${detailData?.scoreNum}`
              : detailData?.scoreNum)}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="流通方式">
          {detailData?.type}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="订单编号">
          {detailData?.orderNo}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="兑换比例">
          {detailData?.convertRatio}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="领取时间">
          {detailData?.getTime}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="使用时间">
          {detailData && getUseTime(detailData)}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="状态">
          {transStatus(detailData?.status as number)}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="申请提现时间">
          {detailData && getApplyTime(detailData)}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="获赠方UID">
          {detailData?.giveAwayToUid}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label="转赠方UID">
          {detailData?.gainFormUid}
        </Descriptions.Item>
      </Descriptions>
    </Modal>
  );
};
