import React, { useEffect, useState } from "react";
import {
  Descriptions,
  Form,
  Input,
  InputNumber,
  message,
  Modal,
  Select,
  Space,
} from "antd";
import {
  GetUserScoreDetailsType,
  UserScoreDetailsListType,
} from "@/api/interface/pointManageType";
import { PointManageAPI } from "@/api";
import { phoneNumber } from "@/utils/validateUtils";

// 列表的类型
type TableType = (ReturnType<UserScoreDetailsListType> extends Promise<infer T>
  ? T
  : never)["result"]["list"]["userScoreList"];
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}
// 状态类型
const statusList = [
  { value: 0, label: "提现中" },
  { value: 1, label: "提现成功" },
  { value: 2, label: "提现失败" },
];

export const ApproveModal: React.FC<propType> = (props) => {
  ApproveModal.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  /// 表单钩子
  const [form] = Form.useForm();
  // 关闭弹窗
  const handleCancel = () => {
    form.resetFields();
    closed();
  };
  // 提交弹窗
  const handleOk = () => {
    form
      .validateFields()
      .then(async (values) => {
        await handleSubmit(values);
      })
      .catch((err) => {
        message
          .warning({
            content: err.errorFields[0].errors[0],
          })
          .then();
      });
  };
  // 提交数据
  const handleSubmit = async (values: any) => {
    const res = await PointManageAPI.CheckUserScore({
      withdrawDetailsId: data?.withdrawId,
      flag: values.flag,
    });
    if (res && res.code === "200") {
      message.success("操作成功");
      handleCancel();
    } else {
      message.warning(res.message);
    }
  };
  // 转换状态
  const transStatus = (id: number) => {
    return statusList.find((i) => i.value === id)?.label || id;
  };
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      onOk={handleOk}
      destroyOnClose
      width={400}
    >
      <Form
        name="addForm"
        form={form}
        labelAlign="right"
        labelCol={{ span: 8 }}
        // layout="inline"
      >
        <Form.Item label="当前状态">
          <div>{transStatus(data?.status as number)}</div>
        </Form.Item>
        <Form.Item
          label="审批结果"
          name="flag"
          rules={[{ required: true, message: "请选择审批结果" }]}
        >
          <Select
            placeholder="请选择审批结果"
            options={[
              { value: true, label: "通过" },
              { value: false, label: "不通过" },
            ]}
            allowClear
          />
        </Form.Item>
      </Form>
    </Modal>
  );
};
