import { Descriptions, Modal } from "antd";
import React from "react";
import { GetScoreListType } from "@/api/interface/pointManageType";

// 列表的类型
type TableType = (ReturnType<GetScoreListType> extends Promise<infer T>
  ? T
  : never)["result"]["list"];
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const BankCardModal: React.FC<propType> = (props) => {
  BankCardModal.defaultProps = {
    data: undefined,
  };
  const { title, open, closed, data } = props;
  // 关闭弹窗
  const handleCancel = () => {
    closed();
  };
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      // onOk={handleOk}
      footer={null}
      destroyOnClose
    >
      <Descriptions bordered column={1} size="small">
        <Descriptions.Item label="银行卡号">
          {data?.bankCardNumber}
        </Descriptions.Item>
        <Descriptions.Item label="开户银行">
          {data?.accountBank}
        </Descriptions.Item>
        <Descriptions.Item label="支行">{data?.branch}</Descriptions.Item>
        <Descriptions.Item label="开户姓名">
          {data?.accountName}
        </Descriptions.Item>
      </Descriptions>
    </Modal>
  );
};

export default BankCardModal;
