import {
  activeTableItemType,
  activityDataType,
  activityEditType,
  addActivityType,
  endActivityType,
  splitCouponDownType,
} from '../interface/activityManage';
import axios from '../request';

export class ActivityManageAPI {
  // 活动-裂变优惠券-下拉
  static getActivityCouponPullDown: splitCouponDownType = (params) => {
    return axios.get('userpay/coupon/back/getActivityCouponPullDown', {
      params,
    });
  };

  // 活动-新增
  static createActivity: addActivityType = (data) => {
    return axios.post('malluser/activity/create', data);
  };

  // 活动-编辑
  static editActivity: activityEditType = (data) => {
    return axios.post('malluser/activity/update', data);
  };

  // 活动-列表
  static getActivityList: activeTableItemType = (params) => {
    return axios.get('malluser/activity/list', { params });
  };

  //  活动-结束
  static endActivity: endActivityType = (params) => {
    return axios.get('malluser/activity/stop', { params });
  };

  //  活动-数据
  static getActivityData: activityDataType = (params) => {
    return axios.get('malluser/activity/dataInfo', { params });
  };
}
