import {
  addGoodsType,
  detailGoodsType,
  editGoodsType,
  otherServiceType,
  skuUnitType,
} from '~/api/interface/goodsType';
import axios from '../request';

class GoodsAPI {
  //商品-新增
  static addGoods: addGoodsType = (data) => {
    return axios.post('/pms/goods/addGoodsInfo', data);
  };
  //商品-编辑
  static editGoods: editGoodsType = (data) => {
    return axios.post('/pms/goods/editGoodsInfo', data);
  };
  //商品-详情
  static getGoodsDetail: detailGoodsType = (params) => {
    return axios.get('/pms/goods/getGoodsInfoDetail', { params });
  };
  // 商品-单位
  static getSkuUnit: skuUnitType = () => {
    return axios.get('/pms/goods/getSkuUnit');
  };
  //  商品-其它服务列表
  static getOtherServiceList: otherServiceType = () => {
    return axios.get('/pms/goods/listOtherService');
  };
}
export default GoodsAPI;
