import {
  addressInsetType,
  addressListType,
  bindingCompanyMemberType,
  deleteAddressType,
  deleteRoleInfoType,
  editAddressType,
  getCompanyInfoByIdType,
  getRolesListType,
  getSecondDistrictInfo,
  getUserAddressInfoType,
  insertBAccountType,
  insertRoleInfoType,
  insertUserMessageType,
  listBAccountPageType,
  listCompanyAdd,
  listCompanyMembersType,
  listCompanyPage,
  listCompanyRemove,
  listCompanyUpdate,
  listMenuInfoType,
  listRoleInfoPageType,
  listRoleMenuInfoType,
  listUserAndRoleByCompanyIdType,
  removeBAccountType,
  selectUserListType,
  selectUserMessageType,
  systemMessageListByUserType,
  transferLeaderType,
  unbindCompanyMemberType,
  updateBAccountType,
  updatePasswordType,
  updateRoleInfoType,
  updateRoleMenuInfoType,
} from '../interface/systemManageType';
import axios from '../request';

export class SystemManageAPI {
  // 账号-列表
  static listBAccountPage: listBAccountPageType = (params) =>
    axios.post('/userapp/back-user/listBAccountPage', params);

  // 账号-新增
  static insertBAccount: insertBAccountType = (params) =>
    axios.post('/userapp/back-user/insertBAccount', params);

  // 账号-删除(后台)
  static removeBAccountBack: removeBAccountType = (params) =>
    axios.get('/userapp/back-user/removeBAccount', { params });

  // 账号-删除(小程序)
  static removeBAccount: removeBAccountType = (params) =>
    axios.get('/userapp/user-account/removeAppAccount', { params });

  // 账号-修改
  static updateBAccount: updateBAccountType = (params) =>
    axios.post('/userapp/back-user/updateBAccount', params);

  // 账号-修改密码
  static updatePassword: updatePasswordType = (params) =>
    axios.post('/userapp/back-user/updatePassword', params);

  // 单位-列表
  static listCompanyPage: listCompanyPage = (params) =>
    axios.post('/userapp/company/listCompanyPage', params);

  // 单位-新增
  static listCompanyAdd: listCompanyAdd = (params) => axios.post('/userapp/company/add', params);

  // 单位-修改
  static listCompanyUpdate: listCompanyUpdate = (params) =>
    axios.post('/userapp/company/update', params);

  // 单位-删除
  static listCompanyRemove: listCompanyRemove = (params) =>
    axios.get('/userapp/company/remove', { params });
  //单位-详情
  static getCompanyInfoById: getCompanyInfoByIdType = (params) =>
    axios.get('/userapp/company/getCompanyInfoById', { params });

  // 单位-区域
  static getSecondDistrictInfo: getSecondDistrictInfo = (params) =>
    axios.get('/pms/webDevice/getSecondDistrictInfo', { params });
  //单位-成员列表
  static getListCompanyMembers: listCompanyMembersType = (params) =>
    axios.get('/userapp/company/listCompanyMembers', { params });
  //单位-成员绑定
  static bindingCompanyMember: bindingCompanyMemberType = (params) =>
    axios.get('/userapp/company/bindingCompanyMember', { params });
  //单位-成员解除绑定
  static unbindCompanyMember: unbindCompanyMemberType = (params) =>
    axios.get('/userapp/company/unbindCompanyMember', { params });
  //单位-管理员转让
  static transferLeader: transferLeaderType = (params) =>
    axios.get('/userapp/company/transferLeader', { params });

  //账号权限-列表
  static getListRoleInfoPage: listRoleInfoPageType = (data) =>
    axios.post('/userapp/role/listRoleInfoPage', data);

  //  账号权限-新增
  static insertRoleInfo: insertRoleInfoType = (data) =>
    axios.post('/userapp/role/insertRoleInfo', data);
  //  账号权限-编辑
  static updateRoleInfo: updateRoleInfoType = (data) =>
    axios.post('/userapp/role/updateRoleInfo', data);
  //  账号权限-删除
  static deleteRoleInfo: deleteRoleInfoType = (params) =>
    axios.get('/userapp/role/removeRoleInfo', { params });
  //  账号权限-全部菜单列表
  static getListMenuInfo: listMenuInfoType = () => axios.get('/userapp/role-menu/listMenuInfo');
  //  账号权限-根据角色id获取权限
  static getListRoleMenuInfo: listRoleMenuInfoType = (params) =>
    axios.get('/userapp/role/listRoleMenuInfo', { params });
  //账号权限-修改角色菜单权限
  static updateRoleMenuInfo: updateRoleMenuInfoType = (data) =>
    axios.post('/userapp/role/updateRoleMenuInfo', data);

  //  地址管理-新增
  static addressInset: addressInsetType = (data) => axios.post('/oms/user-address/insert', data);
  //  地址管理-列表
  static getAddressList: addressListType = (data) =>
    axios.post('/oms/user-address/selectList', data);
  //  地址管理-编辑
  static editAddress: editAddressType = (data) => axios.post('/oms/user-address/update', data);
  //  地址管理-删除
  static deleteAddress: deleteAddressType = (params) =>
    axios.get('/oms/user-address/deleteById', { params });
  //   地址管理-根据地址id查找
  static getUserAddressInfo: getUserAddressInfoType = (params) =>
    axios.get('/oms/user-address/getUserAddressInfo', { params });

  // 获取角色列表
  static getRolesList: getRolesListType = (params) =>
    axios.get('/userapp/user-account/getRolesList', { params });

  // 根据公司id获取用户id和角色信息
  static listUserAndRoleByCompanyId: listUserAndRoleByCompanyIdType = (params) =>
    axios.get('/userapp/company/listUserAndRoleByCompanyId', { params });

  // 用户信息列表
  static selectUserList: selectUserListType = (params) =>
    axios.get('/userapp/message/selectUserList', { params });

  // 用户聊天详细信息
  static selectUserMessage: selectUserMessageType = (params) =>
    axios.post('/userapp/message/selectUserMessage', params);

  // 用户发送消息
  static insertUserMessage: insertUserMessageType = (params) =>
    axios.post('/userapp/message/insertUserMessage', params);

  // 用户——系统消息列表
  static systemMessageListByUser: systemMessageListByUserType = (params) =>
    axios.post('/userapp/message/systemMessageListByUser', params);
}
