import './index.scss';
import { Button, Col, Row, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table/InternalTable';
const SkuInfo = () => {
  const skuTableColumns: ColumnsType<any> = [
    {
      title: '版本',
      align: 'center',
    },
    {
      title: '是否缺货',
      align: 'center',
    },
    {
      title: '押金',
      align: 'center',
    },
  ];
  return (
    <div className='sku-info'>
      <div className='sku-info-title'>价格库存信息</div>
      <Row>
        <Col span={1}></Col>
        <Col span={22}>
          <div>
            <Button type='primary' icon={<PlusOutlined />} style={{ marginBottom: '10px' }}>
              新增规格
            </Button>
            <Table bordered columns={skuTableColumns} />
          </div>
        </Col>
      </Row>
    </div>
  );
};
export default SkuInfo;
