import RichText from '~/components/richText';
import './index.scss';
import { Col, Row } from 'antd';
import { FC } from 'react';
interface selfProps {
  setIntroduceInfoEvent: (html: string) => void;
  introduceInfo: string;
}

const IntroduceInfo: FC<selfProps> = ({ setIntroduceInfoEvent, introduceInfo }) => {
  const onChange = (html?: string) => {
    setIntroduceInfoEvent(html || '');
  };
  return (
    <div className='introduce-info'>
      <div className='introduce-info-header'>机构介绍:</div>
      <div className='introduce-info-rich'>
        <Row>
          <Col span={1}></Col>
          <Col span={18}>
            <RichText richTextContent={introduceInfo} onChange={onChange} />
          </Col>
        </Row>
      </div>
    </div>
  );
};
export default IntroduceInfo;
