import axios from '../request';
import {
  appletQRCodeType,
  BackEndLoginType,
  batchRemoveBannerInfo,
  exchangeBannerInfo,
  getLoginInfoType,
  getMessageType,
  getSecondDistrictInfoType,
  getUserAccountByPhoneNumType,
  insertBannerInfo,
  insertModuleInfo,
  listBannerInfoPage,
  listModuleInfoPage,
  removeBannerInfo,
  removeModuleInfo,
  updateBannerInfo,
  updateModuleInfo,
  updateModuleInfoRemark,
  uploadOssType,
} from '~/api/interface/commonType';
import { AxiosRequestConfig } from 'axios';

export class CommonAPI {
  // 用户登录
  static BackEndLogin: BackEndLoginType = (params) =>
    axios.post('/userapp/auth/backEndLogin', params);

  // 上传图片
  static uploadOss: uploadOssType = (params) => axios.post('/pms/upload/oss', params);

  // 断点上传
  static uploadOssBP = (params: any, config?: AxiosRequestConfig<any>) =>
    axios.post('/pms/upload/breakpoint', params, config);

  // V1.0.1-宣传模块管理-分页
  static listModuleInfoPage: listModuleInfoPage = (params) =>
    axios.post('/release/module/listModuleInfoPage', params);

  // 修改宣传备注
  static updateModuleInfoRemark: updateModuleInfoRemark = (params) =>
    axios.get('/release/module/updateModuleInfoRemark', { params });

  // V1.0.1-删除宣传模块
  static removeModuleInfo: removeModuleInfo = (params) =>
    axios.get('/release/module/removeModuleInfo', { params });

  // V1.0.1-宣传模块-新增
  static insertModuleInfo: insertModuleInfo = (params) =>
    axios.post('/release/module/insertModuleInfo', params);

  // 宣传模块-修改
  static updateModuleInfo: updateModuleInfo = (params) =>
    axios.post('/release/module/updateModuleInfo', params);

  // V1.0.1-banner管理-分页
  static listBannerInfoPage: listBannerInfoPage = (params) =>
    axios.post('/release/module/listBannerInfoPage', params);

  // V1.0.1-banner-新增
  static insertBannerInfo: insertBannerInfo = (params) =>
    axios.post('/release/module/insertBannerInfo', params);

  // V1.0.1-banner-修改
  static updateBannerInfo: updateBannerInfo = (params) =>
    axios.post('/release/module/updateBannerInfo', params);

  // V1.0.1-banner批量删除
  static batchRemoveBannerInfo: batchRemoveBannerInfo = (params) =>
    axios.post('/release/module/batchRemoveBannerInfo', params);

  // V1.0.1-删除banner
  static removeBannerInfo: removeBannerInfo = (params) =>
    axios.get('/release/module/removeBannerInfo', { params });

  // V1.0.1-banner-排序交换
  static exchangeBannerInfo: exchangeBannerInfo = (params) =>
    axios.post('/release/module/exchangeBannerInfo', params);

  //手机号筛选小程序用户
  static getUserAccountByPhoneNum: getUserAccountByPhoneNumType = (params) =>
    axios.get('/userapp/user-account/getUserAccountByPhoneNum', { params });
  //获取小程序二维码
  static getAppletQRCode: appletQRCodeType = (params) => {
    return axios.get('/userapp/wx/getAppletQRCode', { params });
  };
  //获取登录信息
  static getLoginInfo: getLoginInfoType = (params) =>
    axios.get('/userapp/temp-auth/getLoginInfo', { params });
  //  获取地域
  static getSecondDistrictInfo: getSecondDistrictInfoType = () =>
    axios.get('/pms/appDevice/getSecondDistrictInfo');

  // 后台——消息提示
  static getMessage: getMessageType = () => axios.get('/userapp/back-user/getMessage');
}
