import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';
import tsconfigPaths from 'vite-tsconfig-paths';
import { resolve } from 'path';

// https://vitejs.dev/config/
export default defineConfig({
  base: '/',
  plugins: [react(), tsconfigPaths()],
  server: {
    host: '0.0.0.0',
    proxy: {
      '/api': {
        // target: 'http://192.168.3.111:8099', // 后端女pms
        // target: 'http://192.168.3.111:8077', // 后端女oms
        // target: 'http://192.168.3.111:10001', // 后端女release
        // target: 'http://192.168.3.111:35150', // 后端女user
        // target: 'http://192.168.3.17:8099', // 狗旺
        target: 'https://test.iuav.shop',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api/, ''),
      },
    },
  },
  envDir: resolve(__dirname, 'env'),
  resolve: {
    // 配置别名
    alias: {
      '@': resolve(__dirname, 'src'),
    },
  },
});
