package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.webLogin.LoginUserQO;
import com.mmc.iuav.user.model.vo.WebRegisterVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;

/**
 * @author: zj
 * @Date: 2023/5/16 13:50
 */
public interface AuthService {
    /**
     * 小程序用户登录接口
     *
     * @param wxLoginVO
     * @return
     */
    ResultBody appletLogin(WxLoginVO wxLoginVO);

    /**
     * 后台用户登录
     *
     * @param param
     * @return
     */
    ResultBody backEndLogin(LoginUserQO param);

    /**
     * 小程序用户登录
     *
     * @param unionId
     * @return
     */
    ResultBody testAppletLogin(String unionId);

    /**
     * 小程序确认登录
     *
     * @param loginSuccessDTO
     * @param port
     * @param randomLoginCode
     * @return
     */
    ResultBody tempConfirmLogin(LoginSuccessDTO loginSuccessDTO, Integer port, String randomLoginCode);

    /**
     * 获取用登录信息
     *
     * @param randomLoginCode
     * @return
     */
    ResultBody getLoginInfo(String randomLoginCode);
    /**
     * web端用户注册
     */
    ResultBody webRegister(WebRegisterVO webRegisterVO);

    ResultBody webLogin(LoginUserQO param);

    ResultBody updatePassword(WebRegisterVO webRegisterVO);
}
