package com.mmc.iuav.user.mq.listener;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.user.model.vo.wallet.TopUpOrderVO;
import com.mmc.iuav.user.mq.constant.RabbitmqConstant;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/6/29 10:35 概要：
 */
@Slf4j
@Component
public class OrderMqConsumer {
    @Resource
    PayWalletService payWalletService;

    @RabbitListener(queues = RabbitmqConstant.USER_TOP_UP_SUCCESS_QUEUE)
    public void subscribeDirectQueue(@Payload String topUpOrder, Channel channel, Message message) {
        TopUpOrderVO topUpOrderVO = JSONObject.parseObject(topUpOrder, TopUpOrderVO.class);
        log.info("<==========用户充值成功消费开始：订单信息是---->{}==========>", topUpOrderVO);
        payWalletService.feignTopUpCash(topUpOrderVO);
        log.info("<==========用户充值成功消费结束==========>");
    }
}
