package com.mmc.iuav.user.feign;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.feign.hystrix.PaymentAppApiHystrix;
import com.mmc.iuav.user.model.vo.OrderRequestParamsVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@FeignClient(url = "${iuav.pay.uri}", name = "payment-svc", fallback = PaymentAppApiHystrix.class)
public interface PaymentAppApi {

    @PostMapping("/payment/wechat/pay")
    Map orderPay(@RequestBody OrderRequestParamsVO orderRequestParamsVO, @RequestHeader("token") String token);
}
