package com.mmc.iuav.user.entity.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author Admin
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CurriculumOrderLogVO {
    private Integer userAccountId;
    @ApiModelProperty(value = "云享金消耗金额")
    private BigDecimal  cashAmtPaid;
    @ApiModelProperty(value = "佣金消耗金额")
    private BigDecimal salaryAmtPaid;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    public PayLogDO buildPayLog() {
        return PayLogDO.builder().userAccountId(this.userAccountId)
                .cashAmtPaid(this.cashAmtPaid != null ? this.cashAmtPaid.negate() : BigDecimal.ZERO)
                .salaryAmtPaid(this.salaryAmtPaid != null ? this.salaryAmtPaid.negate() : BigDecimal.ZERO)
                .payNo(this.orderNo)
                .build();
    }
}