package com.mmc.iuav.user.client;


import com.alibaba.fastjson2.JSONArray;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.vo.LicenseOrganizationsVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static com.alibaba.fastjson2.JSON.parseObject;

@Component
public class ImsClient {

    @Value("${iuav.ims.uri}")
    private String imsAppUri;

    @Autowired
    private RestTemplate restTemplate;

    public ResultBody insertOrganizations(CompanyInfoDO companyInfoDO, String token,Integer backUserId){
        LicenseOrganizationsVO licenseOrganizationsVO = companyInfoDO.buildLicenseOrganizationsVO();
        licenseOrganizationsVO.setDetail("无");
        licenseOrganizationsVO.setTestCenter(0);
        licenseOrganizationsVO.setBackUserId(backUserId);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);

        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(licenseOrganizationsVO), headers);
        ResponseEntity<ResultBody> responseEntity = restTemplate.exchange(imsAppUri + "/release/licence/background/insertOrg", HttpMethod.POST, entity, ResultBody.class);
        return responseEntity.getBody();
    }

    public int getDynamicMessageSum() {
        HttpHeaders headers = new HttpHeaders();

        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<ResultBody> responseEntity = restTemplate.exchange(imsAppUri + "/release/backstage/forum/getNotCheckDynamicSum", HttpMethod.GET, entity, ResultBody.class);
        ResultBody body = responseEntity.getBody();
        return (int) body.getResult();
    }
}
